/*
 * Decompiled with CFR 0.152.
 */
package org.structr.web.entity.feed;

import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.common.View;
import org.structr.common.error.FrameworkException;
import org.structr.common.fulltext.FulltextIndexer;
import org.structr.common.fulltext.Indexable;
import org.structr.core.Export;
import org.structr.core.GraphObject;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.property.Property;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.StartNode;
import org.structr.core.property.StringProperty;
import org.structr.schema.SchemaService;
import org.structr.web.entity.feed.FeedItem;
import org.structr.web.entity.relation.FeedItemContents;

public class FeedItemContent
extends AbstractNode
implements Indexable {
    private static final Logger logger = LoggerFactory.getLogger((String)FeedItemContent.class.getName());
    public static final Property<String> mode = new StringProperty("mode");
    public static final Property<String> itemType = new StringProperty("itemType");
    public static final Property<String> value = new StringProperty("value");
    public static final Property<FeedItem> item = new StartNode("item", FeedItemContents.class);
    public static final View publicView = new View(FeedItemContent.class, "public", new Property[]{type, contentType, owner, mode, itemType, value});
    public static final View uiView = new View(FeedItemContent.class, "ui", new Property[]{type, contentType, owner, extractedContent, indexedWords, mode, itemType, value, item});

    public void afterCreation(SecurityContext securityContext) {
        try {
            FulltextIndexer fulltextIndexer = StructrApp.getInstance((SecurityContext)securityContext).getFulltextIndexer(new Object[0]);
            fulltextIndexer.addToFulltextIndex((Indexable)this);
        }
        catch (FrameworkException frameworkException) {
            logger.warn("Unable to index " + (Object)((Object)this), (Throwable)frameworkException);
        }
    }

    @Export
    public GraphObject getSearchContext(String string, int n) {
        String string2 = (String)this.getProperty((PropertyKey)extractedContent);
        if (string2 != null) {
            FulltextIndexer fulltextIndexer = StructrApp.getInstance((SecurityContext)this.securityContext).getFulltextIndexer(new Object[0]);
            return fulltextIndexer.getContextObject(string, string2, n);
        }
        return null;
    }

    public InputStream getInputStream() {
        return IOUtils.toInputStream((String)((String)this.getProperty((PropertyKey)value)));
    }

    static {
        SchemaService.registerBuiltinTypeOverride((String)"FeedItemContent", (String)FeedItemContent.class.getName());
    }
}

