/*
 * Decompiled with CFR 0.152.
 */
package org.structr.odf.entity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import org.odftoolkit.odfdom.doc.OdfSpreadsheetDocument;
import org.odftoolkit.odfdom.doc.table.OdfTable;
import org.odftoolkit.odfdom.doc.table.OdfTableCell;
import org.structr.common.error.FrameworkException;
import org.structr.core.Export;
import org.structr.core.GraphObject;
import org.structr.core.GraphObjectMap;
import org.structr.core.Result;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.StringProperty;
import org.structr.odf.entity.ODFExporter;
import org.structr.schema.SchemaService;
import org.structr.transform.VirtualType;
import org.structr.web.entity.FileBase;

public class ODSExporter
extends ODFExporter {
    private void writeCollectionToCells(OdfTable odfTable, OdfTableCell odfTableCell, Collection collection) {
        int n = odfTableCell.getColumnIndex();
        int n2 = odfTableCell.getRowIndex();
        for (Object e : collection) {
            Object object;
            Object object2;
            if (e instanceof String[]) {
                object2 = (String[])e;
                object = new ArrayList<String>(Arrays.asList(object2));
                StringJoiner stringJoiner = new StringJoiner(",");
                object.forEach(string -> stringJoiner.add((CharSequence)string));
                this.writeObjectToCell(odfTable.getCellByPosition(n, n2), stringJoiner.toString());
            } else if (e instanceof Collection) {
                object2 = (Collection)e;
                object = new StringJoiner(",");
                object2.forEach(arg_0 -> ODSExporter.lambda$writeCollectionToCells$1((StringJoiner)object, arg_0));
                this.writeObjectToCell(odfTable.getCellByPosition(n, n2), ((StringJoiner)object).toString());
            } else {
                this.writeObjectToCell(odfTable.getCellByPosition(n, n2), e);
            }
            ++n2;
        }
    }

    private void writeObjectToCell(OdfTableCell odfTableCell, Object object) {
        if (object instanceof String) {
            odfTableCell.setStringValue((String)object);
        } else if (object instanceof Integer) {
            Integer n = (Integer)object;
            odfTableCell.setDoubleValue(Double.valueOf(n.doubleValue()));
        } else if (object instanceof Double) {
            odfTableCell.setDoubleValue((Double)object);
        } else if (object instanceof Boolean) {
            odfTableCell.setBooleanValue((Boolean)object);
        } else if (object instanceof AbstractNode) {
            AbstractNode abstractNode = (AbstractNode)object;
            odfTableCell.setStringValue((String)abstractNode.getProperty((PropertyKey)new StringProperty("id")));
        } else if (object != null) {
            odfTableCell.setStringValue(object.toString());
        }
    }

    @Export
    public void exportAttributes(String string) throws FrameworkException {
        FileBase fileBase = (FileBase)this.getProperty((PropertyKey)resultDocument);
        VirtualType virtualType = (VirtualType)this.getProperty((PropertyKey)transformationProvider);
        try {
            App app = StructrApp.getInstance();
            Result result = app.nodeQuery(AbstractNode.class).and((PropertyKey)GraphObject.id, (Object)string).getResult();
            Result result2 = virtualType.transformOutput(this.securityContext, AbstractNode.class, result);
            HashMap hashMap = new HashMap();
            GraphObjectMap graphObjectMap = (GraphObjectMap)result2.get(0);
            graphObjectMap.getPropertyKeys(null).forEach(propertyKey -> hashMap.put(propertyKey.dbName(), graphObjectMap.getProperty(propertyKey)));
            OdfSpreadsheetDocument odfSpreadsheetDocument = OdfSpreadsheetDocument.loadDocument((String)fileBase.getFileOnDisk().getAbsolutePath());
            OdfTable odfTable = (OdfTable)odfSpreadsheetDocument.getTableList().get(0);
            for (Map.Entry entry : hashMap.entrySet()) {
                String[] stringArray;
                String string2 = (String)entry.getKey();
                Object v = entry.getValue();
                if (v instanceof Collection) {
                    stringArray = (String[])v;
                    this.writeCollectionToCells(odfTable, odfTable.getCellByPosition(string2), (Collection)stringArray);
                    continue;
                }
                if (v instanceof String[]) {
                    stringArray = (String[])v;
                    ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
                    this.writeCollectionToCells(odfTable, odfTable.getCellByPosition(string2), arrayList);
                    continue;
                }
                this.writeObjectToCell(odfTable.getCellByPosition(string2), v);
            }
            odfSpreadsheetDocument.save(fileBase.getFileOnDisk().getAbsolutePath());
            odfSpreadsheetDocument.close();
        }
        catch (Exception exception) {
            logger.error("Error while exporting to ODS", (Throwable)exception);
        }
    }

    private static /* synthetic */ void lambda$writeCollectionToCells$1(StringJoiner stringJoiner, Object object) {
        stringJoiner.add(object.toString());
    }

    static {
        SchemaService.registerBuiltinTypeOverride((String)"ODSExporter", (String)ODSExporter.class.getName());
    }
}

