/*
 * Decompiled with CFR 0.152.
 */
package org.structr.odf.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.odftoolkit.simple.TextDocument;
import org.structr.common.error.FrameworkException;
import org.structr.core.Export;
import org.structr.core.GraphObject;
import org.structr.core.GraphObjectMap;
import org.structr.core.Result;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.property.PropertyKey;
import org.structr.odf.entity.ODFExporter;
import org.structr.schema.SchemaService;
import org.structr.transform.VirtualType;
import org.structr.web.entity.FileBase;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ODTExporter
extends ODFExporter {
    private final String ODT_FIELD_TAG_NAME = "text:user-field-decl";
    private final String ODT_FIELD_ATTRIBUTE_NAME = "text:name";
    private final String ODT_FIELD_ATTRIBUTE_VALUE = "office:string-value";

    @Export
    public void exportAttributes(String string2) throws FrameworkException {
        FileBase fileBase = (FileBase)this.getProperty((PropertyKey)resultDocument);
        VirtualType virtualType = (VirtualType)this.getProperty((PropertyKey)transformationProvider);
        try {
            App app = StructrApp.getInstance();
            Result result = app.nodeQuery(AbstractNode.class).and((PropertyKey)GraphObject.id, (Object)string2).getResult();
            Result result2 = virtualType.transformOutput(this.securityContext, AbstractNode.class, result);
            HashMap hashMap = new HashMap();
            GraphObjectMap graphObjectMap = (GraphObjectMap)result2.get(0);
            graphObjectMap.getPropertyKeys(null).forEach(propertyKey -> hashMap.put(propertyKey.dbName(), graphObjectMap.getProperty(propertyKey)));
            TextDocument textDocument = TextDocument.loadDocument((String)fileBase.getFileOnDisk().getAbsolutePath());
            NodeList nodeList = textDocument.getContentRoot().getElementsByTagName("text:user-field-decl");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Serializable serializable;
                Object object2;
                Node node = nodeList.item(i);
                NamedNodeMap namedNodeMap = node.getAttributes();
                Node node2 = namedNodeMap.getNamedItem("text:name");
                Object v = hashMap.get(node2.getNodeValue());
                Node node3 = namedNodeMap.getNamedItem("office:string-value");
                if (v == null) continue;
                if (v instanceof String[]) {
                    object2 = (String[])v;
                    serializable = new ArrayList<String>(Arrays.asList(object2));
                    StringBuilder stringBuilder = new StringBuilder();
                    serializable.forEach(string -> stringBuilder.append(string + "\n"));
                    node3.setNodeValue(stringBuilder.toString());
                    continue;
                }
                if (v instanceof Collection) {
                    object2 = (Collection)v;
                    serializable = new StringBuilder();
                    object2.forEach(object -> serializable.append(object + "\n"));
                    node3.setNodeValue(((StringBuilder)serializable).toString());
                    continue;
                }
                node3.setNodeValue(v.toString());
            }
            textDocument.save(fileBase.getFileOnDisk().getAbsolutePath());
            textDocument.close();
        }
        catch (Exception exception) {
            logger.error("Error while exporting to ODT", (Throwable)exception);
        }
    }

    static {
        SchemaService.registerBuiltinTypeOverride((String)"ODTExporter", (String)ODTExporter.class.getName());
    }
}

