/*
 * Decompiled with CFR 0.152.
 */
package org.structr.cloud;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.Cipher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.config.Settings;
import org.structr.api.service.Command;
import org.structr.api.service.RunnableService;
import org.structr.api.service.StructrServices;
import org.structr.cloud.CloudConnection;
import org.structr.cloud.CloudHost;
import org.structr.cloud.CloudListener;
import org.structr.cloud.CloudTransmission;
import org.structr.cloud.message.AuthenticationRequest;
import org.structr.cloud.message.Begin;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;

public class CloudService
extends Thread
implements RunnableService {
    private static final Logger logger = LoggerFactory.getLogger((String)CloudService.class.getName());
    private static final int DefaultTcpPort = 54555;
    public static final int PROTOCOL_VERSION = 4;
    public static final int CHUNK_SIZE = 65536;
    public static final int BUFFER_SIZE = 262144;
    public static final int LIVE_PACKET_COUNT = 200;
    public static final long AUTH_TIMEOUT = 10000L;
    public static final long DEFAULT_TIMEOUT = 10000L;
    public static final String STREAM_CIPHER = "RC4";
    public static boolean DEBUG = false;
    private ServerSocket serverSocket = null;
    private boolean running = false;
    private int tcpPort = 54555;

    public CloudService() {
        super("CloudService");
        this.setDaemon(true);
    }

    public void injectArguments(Command command) {
    }

    public void initialize(StructrServices structrServices) {
        this.tcpPort = (Integer)Settings.TcpPort.getValue();
        DEBUG = (Boolean)Settings.getBooleanSetting((String[])new String[]{"sync.debug"}).getValue((Object)false);
    }

    public void initialized() {
    }

    public void shutdown() {
        try {
            this.serverSocket.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void startService() throws Exception {
        this.serverSocket = new ServerSocket(this.tcpPort);
        this.running = true;
        this.start();
        logger.info("CloudService successfully started.");
    }

    @Override
    public void run() {
        while (this.running) {
            try {
                new CloudConnection(SecurityContext.getSuperUserInstance(), this.serverSocket.accept(), null).start();
            }
            catch (IOException iOException) {}
        }
    }

    public void stopService() {
        this.shutdown();
    }

    public boolean runOnStartup() {
        return true;
    }

    public boolean isVital() {
        return false;
    }

    public String getModuleName() {
        return "cloud";
    }

    public static <T> T doRemote(SecurityContext securityContext, CloudTransmission<T> cloudTransmission, CloudHost cloudHost, CloudListener cloudListener) throws FrameworkException {
        CloudConnection cloudConnection = null;
        int n = 128;
        T t = null;
        try {
            n = Cipher.getMaxAllowedKeyLength(STREAM_CIPHER);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            logger.warn("", (Throwable)noSuchAlgorithmException);
        }
        try {
            cloudConnection = new CloudConnection(securityContext, new Socket(cloudHost.getHostName(), cloudHost.getPort()), cloudListener);
            cloudConnection.start();
            if (cloudListener != null) {
                cloudListener.transmissionStarted();
            }
            cloudConnection.send(new Begin());
            cloudConnection.setPassword(cloudHost.getPassword());
            cloudConnection.send(new AuthenticationRequest(cloudHost.getUserName(), n));
            cloudConnection.waitForAuthentication();
            t = cloudTransmission.doRemote(cloudConnection);
            cloudConnection.waitForClose(2000);
            cloudConnection.close();
            if (cloudListener != null) {
                cloudListener.transmissionFinished();
            }
        }
        catch (IOException iOException) {
            logger.warn("", (Throwable)iOException);
            throw new FrameworkException(504, "Unable to connect to remote server: " + iOException.getMessage());
        }
        finally {
            if (cloudConnection != null) {
                cloudConnection.close();
            }
        }
        return t;
    }

    public static byte[] trimToSize(byte[] byArray, int n) {
        if (n < Integer.MAX_VALUE) {
            return Arrays.copyOfRange(byArray, 0, Math.min(byArray.length, n / 8));
        }
        return byArray;
    }
}

