/*
 * Decompiled with CFR 0.152.
 */
package org.structr.cloud;

import java.io.DataInputStream;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.structr.cloud.CloudConnection;
import org.structr.cloud.message.Message;

public class Receiver
extends Thread {
    private final BlockingQueue<Message> inputQueue = new ArrayBlockingQueue<Message>(10000);
    private DataInputStream inputStream = null;
    private CloudConnection connection = null;

    public Receiver(CloudConnection cloudConnection, DataInputStream dataInputStream) {
        super("Receiver of " + cloudConnection.getName());
        this.setDaemon(true);
        this.inputStream = dataInputStream;
        this.connection = cloudConnection;
    }

    @Override
    public void run() {
        while (this.connection.isConnected()) {
            try {
                Message message = Message.deserialize(this.inputStream);
                if (message == null) continue;
                this.inputQueue.put(message);
            }
            catch (Throwable throwable) {
                this.connection.close();
            }
        }
    }

    public Message receive() {
        return (Message)this.inputQueue.poll();
    }
}

