/*
 * Decompiled with CFR 0.152.
 */
package org.structr.cloud;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.cloud.CloudConnection;
import org.structr.cloud.message.Message;

public class Sender
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger((String)Sender.class.getName());
    private final BlockingQueue<Message> outputQueue = new ArrayBlockingQueue<Message>(10000);
    private DataOutputStream outputStream = null;
    private CloudConnection connection = null;

    public Sender(CloudConnection cloudConnection, DataOutputStream dataOutputStream) {
        super("Sender of " + cloudConnection.getName());
        this.setDaemon(true);
        this.outputStream = dataOutputStream;
        this.connection = cloudConnection;
        try {
            dataOutputStream.flush();
        }
        catch (IOException iOException) {
            logger.warn("", (Throwable)iOException);
        }
    }

    @Override
    public void run() {
        while (this.connection.isConnected()) {
            try {
                while (!this.outputQueue.isEmpty()) {
                    Message message = (Message)this.outputQueue.poll();
                    if (message == null) continue;
                    message.serialize(this.outputStream);
                    message.afterSend(this.connection);
                }
                this.outputStream.flush();
            }
            catch (Throwable throwable) {
                this.connection.close();
            }
            try {
                Thread.yield();
            }
            catch (Throwable throwable) {}
        }
    }

    public void send(Message message) {
        try {
            this.outputQueue.put(message);
        }
        catch (InterruptedException interruptedException) {
            logger.warn("", (Throwable)interruptedException);
        }
    }
}

