/*
 * Decompiled with CFR 0.152.
 */
package org.structr.cloud.message;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.structr.api.graph.PropertyContainer;
import org.structr.cloud.message.Message;
import org.structr.core.graph.SyncCommand;

public abstract class DataContainer
extends Message {
    protected Map<String, Object> properties = new LinkedHashMap<String, Object>();
    protected int sequenceNumber = 0;

    public DataContainer() {
    }

    public DataContainer(int n) {
        this.sequenceNumber = n;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public int getSequenceNumber() {
        return this.sequenceNumber;
    }

    @Override
    protected void deserializeFrom(DataInputStream dataInputStream) throws IOException {
        this.sequenceNumber = (Integer)SyncCommand.deserialize((DataInputStream)dataInputStream);
        int n = (Integer)SyncCommand.deserialize((DataInputStream)dataInputStream);
        for (int i = 0; i < n; ++i) {
            String string = (String)SyncCommand.deserialize((DataInputStream)dataInputStream);
            Object object = SyncCommand.deserialize((DataInputStream)dataInputStream);
            this.properties.put(string, object);
        }
    }

    @Override
    protected void serializeTo(DataOutputStream dataOutputStream) throws IOException {
        SyncCommand.serialize((DataOutputStream)dataOutputStream, (Object)this.sequenceNumber);
        SyncCommand.serialize((DataOutputStream)dataOutputStream, (Object)this.properties.size());
        for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
            SyncCommand.serialize((DataOutputStream)dataOutputStream, (Object)entry.getKey());
            SyncCommand.serialize((DataOutputStream)dataOutputStream, (Object)entry.getValue());
        }
    }

    protected void collectProperties(PropertyContainer propertyContainer, Iterable<String> iterable) {
        for (String string : iterable) {
            Object object = propertyContainer.getProperty(string);
            if (object == null) continue;
            this.properties.put(string, object);
        }
    }
}

