/*
 * Decompiled with CFR 0.152.
 */
package org.structr.cloud.message;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.structr.cloud.CloudConnection;
import org.structr.cloud.message.DataContainer;
import org.structr.common.error.FrameworkException;
import org.structr.core.graph.SyncCommand;

public class FileNodeChunk
extends DataContainer {
    protected String containerId = null;
    protected int chunkSize = 0;
    protected long fileSize = 0L;
    protected byte[] binaryContent;

    public FileNodeChunk() {
        super(0);
    }

    public FileNodeChunk(String string, long l, int n, int n2) {
        super(n);
        this.containerId = string;
        this.chunkSize = n2;
        this.fileSize = l;
        this.binaryContent = new byte[n2];
    }

    public byte[] getBuffer() {
        return this.binaryContent;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public byte[] getBinaryContent() {
        return this.binaryContent;
    }

    public String getContainerId() {
        return this.containerId;
    }

    @Override
    public String toString() {
        return "FileNodeChunk()";
    }

    @Override
    public void onRequest(CloudConnection cloudConnection) throws IOException, FrameworkException {
        cloudConnection.fileChunk(this);
        this.sendKeepalive(cloudConnection);
    }

    @Override
    public void onResponse(CloudConnection cloudConnection) throws IOException, FrameworkException {
    }

    @Override
    public void afterSend(CloudConnection cloudConnection) {
    }

    @Override
    protected void deserializeFrom(DataInputStream dataInputStream) throws IOException {
        this.containerId = (String)SyncCommand.deserialize((DataInputStream)dataInputStream);
        this.chunkSize = (Integer)SyncCommand.deserialize((DataInputStream)dataInputStream);
        this.fileSize = (Long)SyncCommand.deserialize((DataInputStream)dataInputStream);
        this.binaryContent = SyncCommand.deserializeData((DataInputStream)dataInputStream);
        super.deserializeFrom(dataInputStream);
    }

    @Override
    protected void serializeTo(DataOutputStream dataOutputStream) throws IOException {
        SyncCommand.serialize((DataOutputStream)dataOutputStream, (Object)this.containerId);
        SyncCommand.serialize((DataOutputStream)dataOutputStream, (Object)this.chunkSize);
        SyncCommand.serialize((DataOutputStream)dataOutputStream, (Object)this.fileSize);
        SyncCommand.serializeData((DataOutputStream)dataOutputStream, (byte[])this.binaryContent);
        super.serializeTo(dataOutputStream);
    }
}

