/*
 * Decompiled with CFR 0.152.
 */
package org.structr.cloud.message;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.structr.api.graph.PropertyContainer;
import org.structr.cloud.CloudConnection;
import org.structr.cloud.message.DataContainer;
import org.structr.common.error.FrameworkException;
import org.structr.core.graph.NodeInterface;
import org.structr.core.graph.SyncCommand;

public class NodeDataContainer
extends DataContainer {
    protected String sourceNodeId = null;
    protected String type = null;

    public NodeDataContainer() {
        super(0);
    }

    public NodeDataContainer(NodeInterface nodeInterface, int n) throws FrameworkException {
        this(nodeInterface, n, nodeInterface.getNode().getPropertyKeys());
    }

    public NodeDataContainer(NodeInterface nodeInterface, int n, Iterable<String> iterable) throws FrameworkException {
        super(n);
        this.type = nodeInterface.getClass().getSimpleName();
        this.sourceNodeId = nodeInterface.getUuid();
        this.collectProperties((PropertyContainer)nodeInterface.getNode(), iterable);
    }

    public String getSourceNodeId() {
        return this.sourceNodeId;
    }

    public String getType() {
        return this.type;
    }

    @Override
    public void onRequest(CloudConnection cloudConnection) throws IOException, FrameworkException {
        cloudConnection.storeNode(this);
        this.sendKeepalive(cloudConnection);
    }

    @Override
    public void onResponse(CloudConnection cloudConnection) throws IOException, FrameworkException {
    }

    @Override
    public void afterSend(CloudConnection cloudConnection) {
    }

    @Override
    protected void deserializeFrom(DataInputStream dataInputStream) throws IOException {
        this.sourceNodeId = (String)SyncCommand.deserialize((DataInputStream)dataInputStream);
        this.type = (String)SyncCommand.deserialize((DataInputStream)dataInputStream);
        super.deserializeFrom(dataInputStream);
    }

    @Override
    protected void serializeTo(DataOutputStream dataOutputStream) throws IOException {
        SyncCommand.serialize((DataOutputStream)dataOutputStream, (Object)this.sourceNodeId);
        SyncCommand.serialize((DataOutputStream)dataOutputStream, (Object)this.type);
        super.serializeTo(dataOutputStream);
    }
}

