/*
 * Decompiled with CFR 0.152.
 */
package org.structr.cloud.message;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import org.structr.cloud.CloudConnection;
import org.structr.cloud.message.FileNodeDataContainer;
import org.structr.cloud.message.PullChunk;
import org.structr.common.error.FrameworkException;
import org.structr.core.graph.NodeInterface;
import org.structr.core.graph.SyncCommand;
import org.structr.dynamic.File;

public class PullFile
extends FileNodeDataContainer {
    private String key = null;
    private int nodeIndex = 0;

    public PullFile() throws FrameworkException {
    }

    public PullFile(String string, int n) throws FrameworkException {
        this.key = string;
        this.nodeIndex = n;
    }

    @Override
    public void onRequest(CloudConnection cloudConnection) throws IOException, FrameworkException {
        Object object = cloudConnection.getValue(this.key + "Nodes");
        if (object instanceof List) {
            List list = (List)object;
            NodeInterface nodeInterface = (NodeInterface)list.get(this.nodeIndex);
            File file = (File)nodeInterface;
            cloudConnection.send(new FileNodeDataContainer(file));
        }
    }

    @Override
    public void onResponse(CloudConnection cloudConnection) throws IOException, FrameworkException {
        int n = Long.valueOf(this.getFileSize() / 65536L).intValue() + 1;
        cloudConnection.beginFile(this);
        for (int i = 0; i < n; ++i) {
            PullChunk pullChunk = new PullChunk(this.sourceNodeId, this.sequenceNumber++, this.getFileSize());
            cloudConnection.send(pullChunk);
        }
    }

    @Override
    public void afterSend(CloudConnection cloudConnection) {
    }

    @Override
    protected void deserializeFrom(DataInputStream dataInputStream) throws IOException {
        this.key = (String)SyncCommand.deserialize((DataInputStream)dataInputStream);
        this.nodeIndex = (Integer)SyncCommand.deserialize((DataInputStream)dataInputStream);
        super.deserializeFrom(dataInputStream);
    }

    @Override
    protected void serializeTo(DataOutputStream dataOutputStream) throws IOException {
        SyncCommand.serialize((DataOutputStream)dataOutputStream, (Object)this.key);
        SyncCommand.serialize((DataOutputStream)dataOutputStream, (Object)this.nodeIndex);
        super.serializeTo(dataOutputStream);
    }
}

