/*
 * Decompiled with CFR 0.152.
 */
package org.structr.cloud.message;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import org.structr.cloud.CloudConnection;
import org.structr.cloud.message.NodeDataContainer;
import org.structr.cloud.transmission.PushTransmission;
import org.structr.common.error.FrameworkException;
import org.structr.core.graph.NodeInterface;
import org.structr.core.graph.SyncCommand;
import org.structr.dynamic.File;

public class PullNode
extends NodeDataContainer {
    protected String key = null;
    protected int nodeIndex = 0;

    public PullNode() {
    }

    public PullNode(String string, int n) {
        this.key = string;
        this.nodeIndex = n;
    }

    @Override
    public void onRequest(CloudConnection cloudConnection) throws IOException, FrameworkException {
        Object object = cloudConnection.getValue(this.key + "Nodes");
        if (object instanceof List) {
            List list = (List)object;
            NodeInterface nodeInterface = (NodeInterface)list.get(this.nodeIndex);
            if (nodeInterface instanceof File) {
                PushTransmission.sendFile(cloudConnection, (File)nodeInterface, 65536);
            } else {
                cloudConnection.send(new NodeDataContainer(nodeInterface, this.nodeIndex));
            }
        }
    }

    @Override
    public void onResponse(CloudConnection cloudConnection) throws IOException, FrameworkException {
    }

    @Override
    public void afterSend(CloudConnection cloudConnection) {
    }

    @Override
    protected void deserializeFrom(DataInputStream dataInputStream) throws IOException {
        this.key = (String)SyncCommand.deserialize((DataInputStream)dataInputStream);
        this.nodeIndex = (Integer)SyncCommand.deserialize((DataInputStream)dataInputStream);
        super.deserializeFrom(dataInputStream);
    }

    @Override
    protected void serializeTo(DataOutputStream dataOutputStream) throws IOException {
        SyncCommand.serialize((DataOutputStream)dataOutputStream, (Object)this.key);
        SyncCommand.serialize((DataOutputStream)dataOutputStream, (Object)this.nodeIndex);
        super.serializeTo(dataOutputStream);
    }
}

