/*
 * Decompiled with CFR 0.152.
 */
package org.structr.cloud.message;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.structr.api.graph.PropertyContainer;
import org.structr.cloud.CloudConnection;
import org.structr.cloud.message.DataContainer;
import org.structr.common.error.FrameworkException;
import org.structr.core.graph.RelationshipInterface;
import org.structr.core.graph.SyncCommand;

public class RelationshipDataContainer
extends DataContainer
implements Comparable<RelationshipDataContainer> {
    protected String sourceStartNodeId;
    protected String sourceEndNodeId;
    protected String relationshipId;
    protected String relType;

    public RelationshipDataContainer() {
    }

    public RelationshipDataContainer(RelationshipInterface relationshipInterface, int n) throws FrameworkException {
        this(relationshipInterface, n, relationshipInterface.getRelationship().getPropertyKeys());
    }

    public RelationshipDataContainer(RelationshipInterface relationshipInterface, int n, Iterable<String> iterable) throws FrameworkException {
        super(n);
        this.relType = relationshipInterface.getClass().getSimpleName();
        this.sourceStartNodeId = relationshipInterface.getSourceNode().getUuid();
        this.sourceEndNodeId = relationshipInterface.getTargetNode().getUuid();
        this.relationshipId = relationshipInterface.getUuid();
        this.collectProperties((PropertyContainer)relationshipInterface.getRelationship(), iterable);
    }

    public String getType() {
        return this.relType;
    }

    public String getSourceStartNodeId() {
        return this.sourceStartNodeId;
    }

    public String getSourceEndNodeId() {
        return this.sourceEndNodeId;
    }

    public String getRelationshipId() {
        return this.relationshipId;
    }

    @Override
    public int compareTo(RelationshipDataContainer relationshipDataContainer) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean equals(Object object) {
        RelationshipDataContainer relationshipDataContainer = (RelationshipDataContainer)object;
        return relationshipDataContainer.hashCode() == this.hashCode();
    }

    public int hashCode() {
        int n = 123;
        if (this.getType() != null) {
            n += this.getType().hashCode() ^ 0xB;
        }
        if (this.getSourceStartNodeId() != null) {
            n += this.getSourceStartNodeId().hashCode() ^ 0xC;
        }
        if (this.getSourceEndNodeId() != null) {
            n += this.getSourceEndNodeId().hashCode() ^ 0xD;
        }
        return n;
    }

    @Override
    public void onRequest(CloudConnection cloudConnection) throws IOException, FrameworkException {
        cloudConnection.storeRelationship(this);
        this.sendKeepalive(cloudConnection);
    }

    @Override
    public void onResponse(CloudConnection cloudConnection) throws IOException, FrameworkException {
    }

    @Override
    public void afterSend(CloudConnection cloudConnection) {
    }

    @Override
    protected void deserializeFrom(DataInputStream dataInputStream) throws IOException {
        this.sourceStartNodeId = (String)SyncCommand.deserialize((DataInputStream)dataInputStream);
        this.sourceEndNodeId = (String)SyncCommand.deserialize((DataInputStream)dataInputStream);
        this.relationshipId = (String)SyncCommand.deserialize((DataInputStream)dataInputStream);
        this.relType = (String)SyncCommand.deserialize((DataInputStream)dataInputStream);
        super.deserializeFrom(dataInputStream);
    }

    @Override
    protected void serializeTo(DataOutputStream dataOutputStream) throws IOException {
        SyncCommand.serialize((DataOutputStream)dataOutputStream, (Object)this.sourceStartNodeId);
        SyncCommand.serialize((DataOutputStream)dataOutputStream, (Object)this.sourceEndNodeId);
        SyncCommand.serialize((DataOutputStream)dataOutputStream, (Object)this.relationshipId);
        SyncCommand.serialize((DataOutputStream)dataOutputStream, (Object)this.relType);
        super.serializeTo(dataOutputStream);
    }
}

