/*
 * Decompiled with CFR 0.152.
 */
package org.structr.cloud.message;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Date;
import org.structr.core.GraphObject;
import org.structr.core.graph.NodeInterface;
import org.structr.core.graph.RelationshipInterface;
import org.structr.core.graph.SyncCommand;
import org.structr.dynamic.File;

public class SyncableInfo {
    private boolean node = false;
    private String id = null;
    private String name = null;
    private String type = null;
    private boolean visibleToPublicUsers = false;
    private boolean visibleToAuthenticatedUsers = false;
    private long size = 0L;
    private long lastModified = 0L;

    public SyncableInfo() {
    }

    public SyncableInfo(GraphObject graphObject) {
        if (graphObject != null) {
            if (graphObject.isNode()) {
                NodeInterface nodeInterface = graphObject.getSyncNode();
                this.id = nodeInterface.getUuid();
                this.name = nodeInterface.getName();
                this.type = nodeInterface.getType();
                this.lastModified = nodeInterface.getLastModifiedDate().getTime();
                this.node = true;
                if (nodeInterface instanceof File) {
                    this.size = ((File)nodeInterface).getSize();
                }
            } else {
                RelationshipInterface relationshipInterface = graphObject.getSyncRelationship();
                this.id = relationshipInterface.getUuid();
                this.name = relationshipInterface.getRelType().name();
                this.type = relationshipInterface.getClass().getSimpleName();
                this.node = false;
            }
        }
    }

    public boolean isNode() {
        return this.node;
    }

    public boolean isRelationship() {
        return !this.isNode();
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public Long getSize() {
        return this.size;
    }

    public Date getLastModified() {
        return new Date(this.lastModified);
    }

    public boolean isVisibleToPublicUsers() {
        return this.visibleToPublicUsers;
    }

    public boolean isVisibleToAuthenticatedUsers() {
        return this.visibleToAuthenticatedUsers;
    }

    protected void deserializeFrom(DataInputStream dataInputStream) throws IOException {
        this.node = (Boolean)SyncCommand.deserialize((DataInputStream)dataInputStream);
        this.id = (String)SyncCommand.deserialize((DataInputStream)dataInputStream);
        this.name = (String)SyncCommand.deserialize((DataInputStream)dataInputStream);
        this.type = (String)SyncCommand.deserialize((DataInputStream)dataInputStream);
        this.visibleToPublicUsers = (Boolean)SyncCommand.deserialize((DataInputStream)dataInputStream);
        this.visibleToAuthenticatedUsers = (Boolean)SyncCommand.deserialize((DataInputStream)dataInputStream);
        this.size = (Long)SyncCommand.deserialize((DataInputStream)dataInputStream);
        this.lastModified = (Long)SyncCommand.deserialize((DataInputStream)dataInputStream);
    }

    protected void serializeTo(DataOutputStream dataOutputStream) throws IOException {
        SyncCommand.serialize((DataOutputStream)dataOutputStream, (Object)this.node);
        SyncCommand.serialize((DataOutputStream)dataOutputStream, (Object)this.id);
        SyncCommand.serialize((DataOutputStream)dataOutputStream, (Object)this.name);
        SyncCommand.serialize((DataOutputStream)dataOutputStream, (Object)this.type);
        SyncCommand.serialize((DataOutputStream)dataOutputStream, (Object)this.visibleToPublicUsers);
        SyncCommand.serialize((DataOutputStream)dataOutputStream, (Object)this.visibleToAuthenticatedUsers);
        SyncCommand.serialize((DataOutputStream)dataOutputStream, (Object)this.size);
        SyncCommand.serialize((DataOutputStream)dataOutputStream, (Object)this.lastModified);
    }
}

