/*
 * Decompiled with CFR 0.152.
 */
package org.structr.cloud.sync;

import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.NotFoundException;
import org.structr.cloud.CloudConnection;
import org.structr.cloud.CloudTransmission;
import org.structr.cloud.message.Delete;
import org.structr.cloud.message.FileNodeChunk;
import org.structr.cloud.message.FileNodeDataContainer;
import org.structr.cloud.message.FileNodeEndChunk;
import org.structr.cloud.message.NodeDataContainer;
import org.structr.cloud.message.RelationshipDataContainer;
import org.structr.cloud.sync.ReplicationStatus;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.app.StructrApp;
import org.structr.core.graph.ModificationEvent;
import org.structr.core.property.PropertyKey;
import org.structr.dynamic.File;

public class SyncTransmission
implements CloudTransmission {
    private static final Logger logger = LoggerFactory.getLogger((String)SyncTransmission.class.getName());
    private List<ModificationEvent> transaction = null;

    public SyncTransmission(List<ModificationEvent> list) {
        this.transaction = list;
    }

    public Boolean doRemote(CloudConnection cloudConnection) throws IOException, FrameworkException {
        int n = 0;
        try (Object object = StructrApp.getInstance().tx();){
            for (ModificationEvent modificationEvent : this.transaction) {
                Object object2;
                GraphObject graphObject = modificationEvent.getGraphObject();
                if (modificationEvent.isDeleted()) {
                    object2 = (String)modificationEvent.getRemovedProperties().get((PropertyKey)GraphObject.id);
                    if (object2 != null) {
                        cloudConnection.send(new Delete((String)object2));
                    }
                } else {
                    try {
                        object2 = new LinkedHashSet();
                        this.mapPropertyKeysToStrings((Set<String>)object2, modificationEvent.getNewProperties().keySet());
                        this.mapPropertyKeysToStrings((Set<String>)object2, modificationEvent.getModifiedProperties().keySet());
                        this.mapPropertyKeysToStrings((Set<String>)object2, modificationEvent.getRemovedProperties().keySet());
                        if (graphObject.isNode()) {
                            if (graphObject instanceof File) {
                                SyncTransmission.sendFile(cloudConnection, (File)graphObject, 65536);
                            } else {
                                cloudConnection.send(new NodeDataContainer(graphObject.getSyncNode(), n, (Iterable<String>)object2));
                            }
                        } else {
                            cloudConnection.send(new RelationshipDataContainer(graphObject.getSyncRelationship(), n, (Iterable<String>)object2));
                        }
                    }
                    catch (NotFoundException notFoundException) {
                        logger.info("Trying to synchronize deleted entity, ignoring");
                    }
                }
                ++n;
            }
            object.success();
        }
        object = StructrApp.getInstance().getInstanceId();
        cloudConnection.send(new ReplicationStatus((String)object, (Long)StructrApp.getInstance().getGlobalSetting((String)object + ".lastModified", (Object)0L)));
        cloudConnection.waitForTransmission();
        return true;
    }

    public static void sendFile(CloudConnection cloudConnection, File file, int n) throws FrameworkException, IOException {
        FileNodeDataContainer fileNodeDataContainer = new FileNodeDataContainer(file);
        cloudConnection.send(fileNodeDataContainer);
        for (FileNodeChunk fileNodeChunk : FileNodeDataContainer.getChunks(file, n)) {
            cloudConnection.send(fileNodeChunk);
        }
        cloudConnection.send(new FileNodeEndChunk(fileNodeDataContainer.getSourceNodeId(), fileNodeDataContainer.getFileSize()));
    }

    private void mapPropertyKeysToStrings(Set<String> set, Set<PropertyKey> set2) {
        for (PropertyKey propertyKey : set2) {
            set.add(propertyKey.dbName());
        }
    }
}

