/*
 * Decompiled with CFR 0.152.
 */
package org.structr.cloud.websocket;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.structr.cloud.CloudService;
import org.structr.cloud.HostInfo;
import org.structr.cloud.WebsocketProgressListener;
import org.structr.cloud.message.ListSyncables;
import org.structr.cloud.message.SyncableInfo;
import org.structr.cloud.transmission.SingleTransmission;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.GraphObjectMap;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.graph.NodeInterface;
import org.structr.core.graph.Tx;
import org.structr.core.property.BooleanProperty;
import org.structr.core.property.Property;
import org.structr.core.property.PropertyKey;
import org.structr.dynamic.File;
import org.structr.websocket.StructrWebSocket;
import org.structr.websocket.command.AbstractCommand;
import org.structr.websocket.message.MessageBuilder;
import org.structr.websocket.message.WebSocketMessage;

public class ListRemoteSyncablesCommand
extends AbstractCommand {
    private static final Property<Boolean> isSynchronized = new BooleanProperty("isSynchronized").defaultValue((Object)false);

    public void processMessage(WebSocketMessage webSocketMessage) {
        Map map = webSocketMessage.getNodeData();
        String string = (String)map.get("username");
        String string2 = (String)map.get("password");
        String string3 = (String)map.get("host");
        String string4 = (String)map.get("key");
        String string5 = (String)map.get("type");
        Long l = (Long)map.get("port");
        if (string3 != null && l != null && string != null && string2 != null && string4 != null) {
            App app = StructrApp.getInstance();
            try (Tx tx = app.tx();){
                StructrWebSocket structrWebSocket = this.getWebSocket();
                List<SyncableInfo> list = CloudService.doRemote(structrWebSocket.getSecurityContext(), new SingleTransmission<List<SyncableInfo>>(new ListSyncables(string5)), new HostInfo(string, string2, string3, l.intValue()), new WebsocketProgressListener(this.getWebSocket(), string4, this.callback));
                if (list != null) {
                    LinkedList<GraphObjectMap> linkedList = new LinkedList<GraphObjectMap>();
                    for (SyncableInfo syncableInfo : list) {
                        GraphObjectMap graphObjectMap = new GraphObjectMap();
                        graphObjectMap.put((PropertyKey)GraphObject.id, (Object)syncableInfo.getId());
                        graphObjectMap.put((PropertyKey)NodeInterface.name, (Object)syncableInfo.getName());
                        graphObjectMap.put((PropertyKey)File.size, (Object)syncableInfo.getSize());
                        graphObjectMap.put((PropertyKey)GraphObject.type, (Object)syncableInfo.getType());
                        graphObjectMap.put((PropertyKey)GraphObject.visibleToPublicUsers, (Object)syncableInfo.isVisibleToPublicUsers());
                        graphObjectMap.put((PropertyKey)GraphObject.visibleToAuthenticatedUsers, (Object)syncableInfo.isVisibleToAuthenticatedUsers());
                        graphObjectMap.put((PropertyKey)GraphObject.lastModifiedDate, (Object)syncableInfo.getLastModified());
                        graphObjectMap.put(isSynchronized, (Object)this.isSynchronized(syncableInfo));
                        linkedList.add(graphObjectMap);
                    }
                    webSocketMessage.setResult(linkedList);
                    structrWebSocket.send(webSocketMessage, true);
                }
                tx.success();
            }
            catch (FrameworkException frameworkException) {
                this.getWebSocket().send(MessageBuilder.status().code(400).message(frameworkException.getMessage()).build(), true);
            }
        } else {
            this.getWebSocket().send(MessageBuilder.status().code(400).message("The PULL command needs sourceId, username, password, host, port and key!").build(), true);
        }
    }

    public String getCommand() {
        return "LIST_SYNCABLES";
    }

    private boolean isSynchronized(SyncableInfo syncableInfo) throws FrameworkException {
        if (syncableInfo.isNode()) {
            return StructrApp.getInstance((SecurityContext)this.getWebSocket().getSecurityContext()).nodeQuery().and((PropertyKey)GraphObject.id, (Object)syncableInfo.getId()).getFirst() != null;
        }
        return StructrApp.getInstance((SecurityContext)this.getWebSocket().getSecurityContext()).relationshipQuery().and((PropertyKey)GraphObject.id, (Object)syncableInfo.getId()).getFirst() != null;
    }

    static {
        StructrWebSocket.addCommand(ListRemoteSyncablesCommand.class);
    }
}

