/*
 * Decompiled with CFR 0.152.
 */
package org.structr.cloud.websocket;

import java.util.Map;
import org.structr.cloud.CloudService;
import org.structr.cloud.HostInfo;
import org.structr.cloud.WebsocketProgressListener;
import org.structr.cloud.transmission.PushTransmission;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.SchemaNode;
import org.structr.core.entity.SchemaRelationshipNode;
import org.structr.core.graph.Tx;
import org.structr.core.property.PropertyKey;
import org.structr.websocket.StructrWebSocket;
import org.structr.websocket.command.AbstractCommand;
import org.structr.websocket.message.MessageBuilder;
import org.structr.websocket.message.WebSocketMessage;

public class PushSchemaCommand
extends AbstractCommand {
    public void processMessage(WebSocketMessage webSocketMessage) {
        Map map = webSocketMessage.getNodeData();
        String string = (String)map.get("username");
        String string2 = (String)map.get("password");
        String string3 = (String)map.get("host");
        Long l = (Long)map.get("port");
        String string4 = (String)map.get("key");
        if (string3 != null && l != null && string != null && string2 != null && string4 != null) {
            App app = StructrApp.getInstance();
            try (Tx tx = app.tx();){
                PushTransmission pushTransmission = new PushTransmission();
                for (SchemaNode schemaNode : app.nodeQuery(SchemaNode.class).getAsList()) {
                    if (!this.isFalseOrNull((Boolean)schemaNode.getProperty((PropertyKey)SchemaNode.isBuiltinType))) continue;
                    pushTransmission.getExportSet().add((GraphObject)schemaNode);
                }
                for (SchemaNode schemaNode : app.nodeQuery(SchemaRelationshipNode.class).getAsList()) {
                    pushTransmission.getExportSet().add((GraphObject)schemaNode);
                }
                CloudService.doRemote(this.webSocket.getSecurityContext(), pushTransmission, new HostInfo(string, string2, string3, l.intValue()), new WebsocketProgressListener(this.getWebSocket(), string4, this.callback));
                tx.success();
            }
            catch (FrameworkException frameworkException) {
                this.getWebSocket().send(MessageBuilder.status().code(400).message(frameworkException.getMessage()).build(), true);
            }
        } else {
            this.getWebSocket().send(MessageBuilder.status().code(400).message("The PUSH_SCHEMA command needs username, password, host, port and key!").build(), true);
        }
    }

    public boolean isFalseOrNull(Boolean bl) {
        return bl == null || bl == false;
    }

    public String getCommand() {
        return "PUSH_SCHEMA";
    }

    static {
        StructrWebSocket.addCommand(PushSchemaCommand.class);
    }
}

