/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.Builtins;
import org.renjin.gcc.runtime.BytePtr;
import org.renjin.gcc.runtime.IntPtr;
import org.renjin.gcc.runtime.Mathlib;
import org.renjin.gcc.runtime.Stdlib;
import org.renjin.nmath.fmax2;
import org.renjin.nmath.lbeta;
import org.renjin.nmath.lgamma;

public class choose {
    private choose() {
    }

    public static double choose(double d, double d2) {
        double d3;
        int[] s_choose = new int[]{0};
        double k0 = d2;
        d2 = Mathlib.round((double)d2);
        if (Builtins.__isnan((double)d) != 0 || Builtins.__isnan((double)d2) != 0) {
            d3 = d + d2;
        } else {
            if (Math.abs(d2 - k0) > 1.0E-7) {
                Stdlib.printf((BytePtr)new BytePtr("'k' (%.2f) must be integer, rounded to %.0f\u0000".getBytes(), 0), (Object[])new Object[]{k0, d2});
            }
            if (d2 < 30.0) {
                double d4;
                double d5;
                double d6;
                double d7;
                if (d - d2 < d2 && d >= 0.0 && (d7 = Math.abs(d - (d6 = Mathlib.round((double)d)))) > (d5 = fmax2.fmax2(1.0, d4 = Math.abs(d)) * 1.0E-7) ^ true) {
                    d2 = d - d2;
                }
                if (d2 < 0.0) {
                    d3 = 0.0;
                } else if (d2 == 0.0) {
                    d3 = 1.0;
                } else {
                    double d8;
                    double d9;
                    double r = d;
                    int j = 2;
                    while ((double)j <= d2) {
                        double d10 = j;
                        double d11 = d - d10 + 1.0;
                        double d12 = j;
                        r = d11 / d12 * r;
                        ++j;
                    }
                    double d13 = Mathlib.round((double)d);
                    double d14 = Math.abs(d - d13);
                    double iftmp$0 = d14 > (d9 = fmax2.fmax2(1.0, d8 = Math.abs(d)) * 1.0E-7) ^ true ? Mathlib.round((double)r) : r;
                    d3 = iftmp$0;
                }
            } else if (d < 0.0) {
                double r = choose.choose(d2 - d - 1.0, d2);
                if (Mathlib.floor((double)(d2 / 2.0)) * 2.0 != d2) {
                    r = -r;
                }
                d3 = r;
            } else {
                double d15 = Mathlib.round((double)d);
                double d16 = Math.abs(d - d15);
                double d17 = Math.abs(d);
                double d18 = fmax2.fmax2(1.0, d17) * 1.0E-7;
                if (d16 > d18 ^ true) {
                    if ((d = Mathlib.round((double)d)) < d2) {
                        d3 = 0.0;
                    } else if (d - d2 < 30.0) {
                        double d19 = d - d2;
                        d3 = choose.choose(d, d19);
                    } else {
                        d3 = Mathlib.round((double)Math.exp(choose.Rf_lfastchoose(d, d2)));
                    }
                } else if (d2 - 1.0 > d) {
                    double r = choose.lfastchoose2(d, d2, new IntPtr(s_choose, 0));
                    double d20 = s_choose[0];
                    double d21 = Math.exp(r);
                    d3 = d20 * d21;
                } else {
                    d3 = Math.exp(choose.Rf_lfastchoose(d, d2));
                }
            }
        }
        return d3;
    }

    public static double lchoose(double d, double d2) {
        double d3;
        int[] s = new int[]{0};
        double k0 = d2;
        d2 = Mathlib.round((double)d2);
        if (Builtins.__isnan((double)d) != 0 || Builtins.__isnan((double)d2) != 0) {
            d3 = d + d2;
        } else {
            if (Math.abs(d2 - k0) > 1.0E-7) {
                Stdlib.printf((BytePtr)new BytePtr("'k' (%.2f) must be integer, rounded to %.0f\u0000".getBytes(), 0), (Object[])new Object[]{k0, d2});
            }
            if (d2 < 2.0) {
                d3 = d2 < 0.0 ? -1.0 / 0.0 : (d2 == 0.0 ? 0.0 : Math.log(Math.abs(d)));
            } else if (d < 0.0) {
                d3 = choose.lchoose(d2 - d - 1.0, d2);
            } else {
                double d4 = Mathlib.round((double)d);
                double d5 = Math.abs(d - d4);
                double d6 = Math.abs(d);
                double d7 = fmax2.fmax2(1.0, d6) * 1.0E-7;
                if (d5 > d7 ^ true) {
                    if ((d = Mathlib.round((double)d)) < d2) {
                        d3 = -1.0 / 0.0;
                    } else if (d - d2 < 2.0) {
                        double d8 = d - d2;
                        d3 = choose.lchoose(d, d8);
                    } else {
                        d3 = choose.Rf_lfastchoose(d, d2);
                    }
                } else {
                    d3 = d2 - 1.0 > d ? choose.lfastchoose2(d, d2, new IntPtr(s, 0)) : choose.Rf_lfastchoose(d, d2);
                }
            }
        }
        return d3;
    }

    public static double lfastchoose2(double d, double d2, IntPtr intPtr) {
        int[] s_choose$array = intPtr.array;
        int s_choose$offset = intPtr.offset;
        double r = lgamma.lgammafn_sign(d - d2 + 1.0, new IntPtr(s_choose$array, s_choose$offset));
        double d3 = lgamma.lgammafn(d + 1.0);
        double d4 = lgamma.lgammafn(d2 + 1.0);
        return d3 - d4 - r;
    }

    public static double Rf_lfastchoose(double d, double d2) {
        double d3 = -Math.log(d + 1.0);
        double d4 = d2 + 1.0;
        double d5 = lbeta.lbeta(d - d2 + 1.0, d4);
        return d3 - d5;
    }
}

