/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.Builtins;
import org.renjin.gcc.runtime.BytePtr;
import org.renjin.gcc.runtime.Mathlib;
import org.renjin.gcc.runtime.Stdlib;
import org.renjin.nmath.dbinom;
import org.renjin.nmath.fmax2;

public class dgeom {
    private dgeom() {
    }

    public static double dgeom(double d, double d2, int n) {
        double d3;
        if (Builtins.__isnan((double)d) != 0 || Builtins.__isnan((double)d2) != 0) {
            d3 = d + d2;
        } else if (d2 <= 0.0 || d2 > 1.0) {
            d3 = 0.0 / 0.0;
        } else {
            double d4 = Mathlib.round((double)d);
            double d5 = Math.abs(d - d4);
            double d6 = Math.abs(d);
            double d7 = fmax2.fmax2(1.0, d6) * 1.0E-7;
            if (d5 > d7) {
                Stdlib.printf((BytePtr)new BytePtr("non-integer x = %f\u0000".getBytes(), 0), (Object[])new Object[]{d});
                double iftmp$0 = n != 0 ? -1.0 / 0.0 : 0.0;
                d3 = iftmp$0;
            } else if (d < 0.0 || Builtins.__finite((double)d) == 0 || d2 == 0.0) {
                double iftmp$1 = n != 0 ? -1.0 / 0.0 : 0.0;
                d3 = iftmp$1;
            } else {
                d = Mathlib.round((double)d);
                double d8 = 1.0 - d2;
                double prob = dbinom.dbinom_raw(0.0, d, d2, d8, n);
                double iftmp$2 = n != 0 ? Math.log(d2) + prob : d2 * prob;
                d3 = iftmp$2;
            }
        }
        return d3;
    }
}

