/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.Builtins;
import org.renjin.gcc.runtime.BytePtr;
import org.renjin.gcc.runtime.Mathlib;
import org.renjin.gcc.runtime.Stdlib;
import org.renjin.nmath.bd0;
import org.renjin.nmath.fmax2;
import org.renjin.nmath.lgamma;
import org.renjin.nmath.stirlerr;

public class dpois {
    private dpois() {
    }

    public static double dpois(double d, double d2, int n) {
        double d3;
        if (Builtins.__isnan((double)d) != 0 || Builtins.__isnan((double)d2) != 0) {
            d3 = d + d2;
        } else if (d2 < 0.0) {
            d3 = 0.0 / 0.0;
        } else {
            double d4 = Mathlib.round((double)d);
            double d5 = Math.abs(d - d4);
            double d6 = Math.abs(d);
            double d7 = fmax2.fmax2(1.0, d6) * 1.0E-7;
            if (d5 > d7) {
                Stdlib.printf((BytePtr)new BytePtr("non-integer x = %f\u0000".getBytes(), 0), (Object[])new Object[]{d});
                double iftmp$0 = n != 0 ? -1.0 / 0.0 : 0.0;
                d3 = iftmp$0;
            } else if (d < 0.0 || Builtins.__finite((double)d) == 0) {
                double iftmp$1 = n != 0 ? -1.0 / 0.0 : 0.0;
                d3 = iftmp$1;
            } else {
                d = Mathlib.round((double)d);
                d3 = dpois.dpois_raw(d, d2, n);
            }
        }
        return d3;
    }

    public static double dpois_raw(double d, double d2, int n) {
        double d3;
        if (d2 == 0.0) {
            double iftmp$2;
            if (d == 0.0) {
                double iftmp$3 = n != 0 ? 0.0 : 1.0;
                iftmp$2 = iftmp$3;
            } else {
                double iftmp$4 = n != 0 ? -1.0 / 0.0 : 0.0;
                iftmp$2 = iftmp$4;
            }
            d3 = iftmp$2;
        } else if (Builtins.__finite((double)d2) == 0) {
            double iftmp$5 = n != 0 ? -1.0 / 0.0 : 0.0;
            d3 = iftmp$5;
        } else if (d < 0.0) {
            double iftmp$6 = n != 0 ? -1.0 / 0.0 : 0.0;
            d3 = iftmp$6;
        } else if (d2 * Double.MIN_NORMAL >= d) {
            double iftmp$7 = n != 0 ? -d2 : Math.exp(-d2);
            d3 = iftmp$7;
        } else if (d * Double.MIN_NORMAL > d2) {
            if (Builtins.__finite((double)d) == 0) {
                double iftmp$8 = n != 0 ? -1.0 / 0.0 : 0.0;
                d3 = iftmp$8;
            } else {
                double iftmp$9;
                if (n != 0) {
                    double d4 = Math.log(d2) * d - d2;
                    double d5 = lgamma.lgammafn(d + 1.0);
                    iftmp$9 = d4 - d5;
                } else {
                    double d6 = Math.log(d2) * d - d2;
                    double d7 = lgamma.lgammafn(d + 1.0);
                    iftmp$9 = Math.exp(d6 - d7);
                }
                d3 = iftmp$9;
            }
        } else {
            double iftmp$10;
            if (n != 0) {
                double d8 = Math.log(d * (Math.PI * 2)) * -0.5;
                double d9 = -stirlerr.Rf_stirlerr(d);
                double d10 = bd0.Rf_bd0(d, d2);
                double d11 = d9 - d10;
                iftmp$10 = d8 + d11;
            } else {
                double d12 = -stirlerr.Rf_stirlerr(d);
                double d13 = bd0.Rf_bd0(d, d2);
                double d14 = Math.exp(d12 - d13);
                double d15 = Mathlib.sqrt((double)(d * (Math.PI * 2)));
                iftmp$10 = d14 / d15;
            }
            d3 = iftmp$10;
        }
        return d3;
    }
}

