/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.Builtins;
import org.renjin.gcc.runtime.BytePtr;
import org.renjin.gcc.runtime.DoublePtr;
import org.renjin.gcc.runtime.IntPtr;
import org.renjin.gcc.runtime.Stdlib;
import org.renjin.nmath.toms708;

public class pbeta {
    private pbeta() {
    }

    public static double pbeta(double d, double d2, double d3, int n, int n2) {
        double d4;
        if (Builtins.__isnan((double)d) != 0 || Builtins.__isnan((double)d2) != 0 || Builtins.__isnan((double)d3) != 0) {
            d4 = d + d2 + d3;
        } else if (d2 < 0.0 || d3 < 0.0) {
            d4 = 0.0 / 0.0;
        } else if (d <= 0.0) {
            double iftmp$0;
            if (n != 0) {
                double iftmp$1 = n2 != 0 ? -1.0 / 0.0 : 0.0;
                iftmp$0 = iftmp$1;
            } else {
                double iftmp$2 = n2 != 0 ? 0.0 : 1.0;
                iftmp$0 = iftmp$2;
            }
            d4 = iftmp$0;
        } else if (d >= 1.0) {
            double iftmp$3;
            if (n != 0) {
                double iftmp$4 = n2 != 0 ? 0.0 : 1.0;
                iftmp$3 = iftmp$4;
            } else {
                double iftmp$5 = n2 != 0 ? -1.0 / 0.0 : 0.0;
                iftmp$3 = iftmp$5;
            }
            d4 = iftmp$3;
        } else {
            d4 = pbeta.pbeta_raw(d, d2, d3, n, n2);
        }
        return d4;
    }

    public static double pbeta_raw(double d, double d2, double d3, int n, int n2) {
        double d4;
        int[] ierr = new int[1];
        double[] wc = new double[1];
        double[] w = new double[1];
        ierr[0] = 0;
        wc[0] = 0.0;
        w[0] = 0.0;
        if (d2 == 0.0 || d3 == 0.0 || Builtins.__finite((double)d2) == 0 || Builtins.__finite((double)d3) == 0) {
            if (d2 == 0.0 && d3 == 0.0) {
                double iftmp$6 = n2 != 0 ? -0.6931471805599453 : 0.5;
                d4 = iftmp$6;
            } else if (d2 == 0.0 || d2 / d3 == 0.0) {
                double iftmp$7;
                if (n != 0) {
                    double iftmp$8 = n2 != 0 ? 0.0 : 1.0;
                    iftmp$7 = iftmp$8;
                } else {
                    double iftmp$9 = n2 != 0 ? -1.0 / 0.0 : 0.0;
                    iftmp$7 = iftmp$9;
                }
                d4 = iftmp$7;
            } else if (d3 == 0.0 || d3 / d2 == 0.0) {
                double iftmp$10;
                if (n != 0) {
                    double iftmp$11 = n2 != 0 ? -1.0 / 0.0 : 0.0;
                    iftmp$10 = iftmp$11;
                } else {
                    double iftmp$12 = n2 != 0 ? 0.0 : 1.0;
                    iftmp$10 = iftmp$12;
                }
                d4 = iftmp$10;
            } else if (d < 0.5) {
                double iftmp$13;
                if (n != 0) {
                    double iftmp$14 = n2 != 0 ? -1.0 / 0.0 : 0.0;
                    iftmp$13 = iftmp$14;
                } else {
                    double iftmp$15 = n2 != 0 ? 0.0 : 1.0;
                    iftmp$13 = iftmp$15;
                }
                d4 = iftmp$13;
            } else {
                double iftmp$16;
                if (n != 0) {
                    double iftmp$17 = n2 != 0 ? 0.0 : 1.0;
                    iftmp$16 = iftmp$17;
                } else {
                    double iftmp$18 = n2 != 0 ? -1.0 / 0.0 : 0.0;
                    iftmp$16 = iftmp$18;
                }
                d4 = iftmp$16;
            }
        } else {
            double x1 = 0.5 - d + 0.5;
            toms708.Rf_bratio(d2, d3, d, x1, new DoublePtr(w, 0), new DoublePtr(wc, 0), new IntPtr(ierr, 0), n2);
            if (ierr[0] != 0 && ierr[0] != 11 && ierr[0] != 14) {
                int ierr$22 = ierr[0];
                Stdlib.printf((BytePtr)new BytePtr("pbeta_raw(%g, a=%g, b=%g, ..) -> bratio() gave error code %d\u0000".getBytes(), 0), (Object[])new Object[]{d, d2, d3, ierr$22});
            }
            double iftmp$23 = n != 0 ? w[0] : wc[0];
            d4 = iftmp$23;
        }
        return d4;
    }
}

