/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.Builtins;
import org.renjin.gcc.runtime.BytePtr;
import org.renjin.gcc.runtime.DoublePtr;
import org.renjin.gcc.runtime.IntPtr;
import org.renjin.gcc.runtime.Mathlib;
import org.renjin.gcc.runtime.Stdlib;
import org.renjin.nmath.pbeta;
import org.renjin.nmath.ppois;
import org.renjin.nmath.toms708;

public class pnbinom {
    private pnbinom() {
    }

    public static double pnbinom_mu(double d, double d2, double d3, int n, int n2) {
        double d4;
        double[] wc = new double[1];
        double[] w = new double[1];
        int[] ierr = new int[1];
        wc[0] = 0.0;
        w[0] = 0.0;
        ierr[0] = 0;
        if (Builtins.__isnan((double)d) != 0 || Builtins.__isnan((double)d2) != 0 || Builtins.__isnan((double)d3) != 0) {
            d4 = d + d2 + d3;
        } else if (Builtins.__finite((double)d3) == 0) {
            d4 = 0.0 / 0.0;
        } else if (d2 < 0.0 || d3 < 0.0) {
            d4 = 0.0 / 0.0;
        } else if (d2 == 0.0) {
            double iftmp$0;
            if (d >= 0.0) {
                double iftmp$1;
                if (n != 0) {
                    double iftmp$2 = n2 != 0 ? 0.0 : 1.0;
                    iftmp$1 = iftmp$2;
                } else {
                    double iftmp$3 = n2 != 0 ? -1.0 / 0.0 : 0.0;
                    iftmp$1 = iftmp$3;
                }
                iftmp$0 = iftmp$1;
            } else {
                double iftmp$4;
                if (n != 0) {
                    double iftmp$5 = n2 != 0 ? -1.0 / 0.0 : 0.0;
                    iftmp$4 = iftmp$5;
                } else {
                    double iftmp$6 = n2 != 0 ? 0.0 : 1.0;
                    iftmp$4 = iftmp$6;
                }
                iftmp$0 = iftmp$4;
            }
            d4 = iftmp$0;
        } else if (d < 0.0) {
            double iftmp$7;
            if (n != 0) {
                double iftmp$8 = n2 != 0 ? -1.0 / 0.0 : 0.0;
                iftmp$7 = iftmp$8;
            } else {
                double iftmp$9 = n2 != 0 ? 0.0 : 1.0;
                iftmp$7 = iftmp$9;
            }
            d4 = iftmp$7;
        } else if (Builtins.__finite((double)d) == 0) {
            double iftmp$10;
            if (n != 0) {
                double iftmp$11 = n2 != 0 ? 0.0 : 1.0;
                iftmp$10 = iftmp$11;
            } else {
                double iftmp$12 = n2 != 0 ? -1.0 / 0.0 : 0.0;
                iftmp$10 = iftmp$12;
            }
            d4 = iftmp$10;
        } else if (Builtins.__finite((double)d2) == 0) {
            d4 = ppois.ppois(d, d3, n, n2);
        } else {
            d = Mathlib.floor((double)(d + 1.0E-7));
            double d5 = d2 + d3;
            double d6 = d3 / d5;
            double d7 = d2 + d3;
            double d8 = d2 / d7;
            double d9 = d + 1.0;
            toms708.Rf_bratio(d2, d9, d8, d6, new DoublePtr(w, 0), new DoublePtr(wc, 0), new IntPtr(ierr, 0), n2);
            if (ierr[0] != 0) {
                int ierr$14 = ierr[0];
                Stdlib.printf((BytePtr)new BytePtr("pnbinom_mu() -> bratio() gave error code %d\u0000".getBytes(), 0), (Object[])new Object[]{ierr$14});
            }
            double iftmp$15 = n != 0 ? w[0] : wc[0];
            d4 = iftmp$15;
        }
        return d4;
    }

    public static double pnbinom(double d, double d2, double d3, int n, int n2) {
        double d4;
        if (Builtins.__isnan((double)d) != 0 || Builtins.__isnan((double)d2) != 0 || Builtins.__isnan((double)d3) != 0) {
            d4 = d + d2 + d3;
        } else if (Builtins.__finite((double)d2) == 0 || Builtins.__finite((double)d3) == 0) {
            d4 = 0.0 / 0.0;
        } else if (d2 < 0.0 || d3 <= 0.0 || d3 > 1.0) {
            d4 = 0.0 / 0.0;
        } else if (d2 == 0.0) {
            double iftmp$16;
            if (d >= 0.0) {
                double iftmp$17;
                if (n != 0) {
                    double iftmp$18 = n2 != 0 ? 0.0 : 1.0;
                    iftmp$17 = iftmp$18;
                } else {
                    double iftmp$19 = n2 != 0 ? -1.0 / 0.0 : 0.0;
                    iftmp$17 = iftmp$19;
                }
                iftmp$16 = iftmp$17;
            } else {
                double iftmp$20;
                if (n != 0) {
                    double iftmp$21 = n2 != 0 ? -1.0 / 0.0 : 0.0;
                    iftmp$20 = iftmp$21;
                } else {
                    double iftmp$22 = n2 != 0 ? 0.0 : 1.0;
                    iftmp$20 = iftmp$22;
                }
                iftmp$16 = iftmp$20;
            }
            d4 = iftmp$16;
        } else if (d < 0.0) {
            double iftmp$23;
            if (n != 0) {
                double iftmp$24 = n2 != 0 ? -1.0 / 0.0 : 0.0;
                iftmp$23 = iftmp$24;
            } else {
                double iftmp$25 = n2 != 0 ? 0.0 : 1.0;
                iftmp$23 = iftmp$25;
            }
            d4 = iftmp$23;
        } else if (Builtins.__finite((double)d) == 0) {
            double iftmp$26;
            if (n != 0) {
                double iftmp$27 = n2 != 0 ? 0.0 : 1.0;
                iftmp$26 = iftmp$27;
            } else {
                double iftmp$28 = n2 != 0 ? -1.0 / 0.0 : 0.0;
                iftmp$26 = iftmp$28;
            }
            d4 = iftmp$26;
        } else {
            d = Mathlib.floor((double)(d + 1.0E-7));
            double d5 = d + 1.0;
            d4 = pbeta.pbeta(d3, d2, d5, n, n2);
        }
        return d4;
    }
}

