/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.Builtins;
import org.renjin.gcc.runtime.BytePtr;
import org.renjin.gcc.runtime.Mathlib;
import org.renjin.gcc.runtime.Stdlib;
import org.renjin.nmath.fmax2;
import org.renjin.nmath.ptukey;

public class qtukey {
    public static double $qtukey$eps = 1.0E-4;
    public static double $qinv$vmax = 120.0;
    public static double $qinv$c5 = 1.4142;
    public static double $qinv$c4 = 1.208;
    public static double $qinv$c3 = 1.214;
    public static double $qinv$c2 = 0.2368;
    public static double $qinv$c1 = 0.8832;
    public static double $qinv$q4 = 0.0038560700634;
    public static double $qinv$p4 = -4.53642210148E-5;
    public static double $qinv$q3 = 0.10353775285;
    public static double $qinv$p3 = -0.204231210125;
    public static double $qinv$q2 = 0.531103462366;
    public static double $qinv$p2 = -0.342242088547;
    public static double $qinv$q1 = 0.588581570495;
    public static double $qinv$p1 = -1.0;
    public static double $qinv$q0 = 0.099348462606;
    public static double $qinv$p0 = 0.322232421088;

    private qtukey() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static double qtukey(double d, double d2, double d3, double d4, int n, int n2) {
        double x1;
        double iftmp$4;
        int maxiter = 0;
        maxiter = 50;
        double ans = 0.0;
        if (Builtins.__isnan((double)d) != 0) return d + d2 + d3 + d4;
        if (Builtins.__isnan((double)d2) != 0) return d + d2 + d3 + d4;
        if (Builtins.__isnan((double)d3) != 0) return d + d2 + d3 + d4;
        if (Builtins.__isnan((double)d4) != 0) return d + d2 + d3 + d4;
        if (d4 < 2.0) return 0.0 / 0.0;
        if (d2 < 1.0) return 0.0 / 0.0;
        if (d3 < 2.0) return 0.0 / 0.0;
        if (n2 != 0) {
            if (d > 0.0) return 0.0 / 0.0;
            if (d == 0.0) {
                if (n == 0) {
                    return 0.0;
                }
                double iftmp$0 = 1.0 / 0.0;
                return iftmp$0;
            }
            double d5 = -1.0 / 0.0;
            if (d == d5) {
                if (n != 0) {
                    return 0.0;
                }
                double iftmp$1 = 1.0 / 0.0;
                return iftmp$1;
            }
        } else {
            if (d < 0.0) return 0.0 / 0.0;
            if (d > 1.0) return 0.0 / 0.0;
            if (d == 0.0) {
                if (n != 0) {
                    return 0.0;
                }
                double iftmp$2 = 1.0 / 0.0;
                return iftmp$2;
            }
            if (d == 1.0) {
                if (n == 0) {
                    return 0.0;
                }
                double iftmp$3 = 1.0 / 0.0;
                return iftmp$3;
            }
        }
        if (n2 != 0) {
            double iftmp$5 = n != 0 ? Math.exp(d) : -Mathlib.expm1((double)d);
            iftmp$4 = iftmp$5;
        } else {
            double iftmp$6 = n == 0 ? 0.5 - d + 0.5 : d;
            iftmp$4 = iftmp$6;
        }
        d = iftmp$4;
        double x0 = qtukey.qinv(d, d3, d4);
        double valx0 = ptukey.ptukey(x0, d2, d3, d4, 1, 0) - d;
        if (valx0 > 0.0) {
            double d6 = x0 - 1.0;
            x1 = fmax2.fmax2(0.0, d6);
        } else {
            x1 = x0 + 1.0;
        }
        double valx1 = ptukey.ptukey(x1, d2, d3, d4, 1, 0) - d;
        int iter = 1;
        while (iter < maxiter) {
            double d7 = (x1 - x0) * valx1;
            double d8 = valx1 - valx0;
            double d9 = d7 / d8;
            ans = x1 - d9;
            valx0 = valx1;
            x0 = x1;
            if (ans < 0.0) {
                ans = 0.0;
                valx1 = -d;
            }
            valx1 = ptukey.ptukey(ans, d2, d3, d4, 1, 0) - d;
            x1 = ans;
            double xabs = Math.abs(x1 - x0);
            double eps$7 = $qtukey$eps;
            if (xabs < eps$7) return ans;
            ++iter;
        }
        byte[] msg = "\u0000".getBytes();
        int msg$offset = 0;
        msg = "convergence failed in '%s'\n\u0000".getBytes();
        msg$offset = 0;
        Stdlib.printf((BytePtr)new BytePtr(msg, msg$offset), (Object[])new Object[]{new BytePtr("qtukey\u0000".getBytes(), 0)});
        return ans;
    }

    public static double qinv(double d, double d2, double d3) {
        double ps;
        double d4 = d * 0.5;
        double d5 = ps = 0.5 - d4;
        double d6 = d5 * d5;
        double yi = Mathlib.sqrt((double)Math.log(1.0 / d6));
        double p4$8 = $qinv$p4;
        double d7 = yi * p4$8;
        double p3$9 = $qinv$p3;
        double d8 = (d7 + p3$9) * yi;
        double p2$10 = $qinv$p2;
        double d9 = (d8 + p2$10) * yi;
        double p1$11 = $qinv$p1;
        double d10 = (d9 + p1$11) * yi;
        double p0$12 = $qinv$p0;
        double d11 = d10 + p0$12;
        double q4$13 = $qinv$q4;
        double d12 = yi * q4$13;
        double q3$14 = $qinv$q3;
        double d13 = (d12 + q3$14) * yi;
        double q2$15 = $qinv$q2;
        double d14 = (d13 + q2$15) * yi;
        double q1$16 = $qinv$q1;
        double d15 = (d14 + q1$16) * yi;
        double q0$17 = $qinv$q0;
        double d16 = d15 + q0$17;
        double t = d11 / d16 + yi;
        double vmax$18 = $qinv$vmax;
        if (d3 < vmax$18) {
            double d17 = t;
            t = (d17 * d17 * t + t) / d3 / 4.0 + t;
        }
        double c1$19 = $qinv$c1;
        double d18 = $qinv$c2 * t;
        double q = c1$19 - d18;
        double vmax$21 = $qinv$vmax;
        if (d3 < vmax$21) {
            double d19 = -$qinv$c3 / d3;
            double d20 = $qinv$c4 * t / d3;
            q = d19 + d20 + q;
        }
        double d21 = Math.log(d2 - 1.0) * q;
        double c5$24 = $qinv$c5;
        return (d21 + c5$24) * t;
    }
}

