/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import java.lang.invoke.MethodHandle;
import org.renjin.gcc.runtime.Builtins;
import org.renjin.gcc.runtime.BytePtr;
import org.renjin.gcc.runtime.DoublePtr;
import org.renjin.gcc.runtime.IntPtr;
import org.renjin.math.Errors;
import org.renjin.nmath.rbinom;

public class rmultinom {
    private rmultinom() {
    }

    public static void rmultinom(MethodHandle methodHandle, int n, DoublePtr doublePtr, int n2, IntPtr intPtr) {
        block14: {
            double[] prob$array = doublePtr.array;
            int prob$offset = doublePtr.offset;
            int[] rN$array = intPtr.array;
            int rN$offset = intPtr.offset;
            double p_tot = 0.0;
            if (n2 > 0) {
                if (n < 0) {
                    rN$array[rN$offset] = -1;
                } else {
                    double pp;
                    int k = 0;
                    while (k < n2) {
                        double[] dArray = prob$array;
                        int n3 = k * 8;
                        int n4 = prob$offset + n3 / 8;
                        pp = dArray[n4];
                        if (Builtins.__finite((double)pp) == 0 || pp < 0.0 || pp > 1.0) {
                            int n5 = k * 4;
                            int[] nArray = rN$array;
                            int n6 = rN$offset + n5 / 4;
                            nArray[n6] = -1;
                            break block14;
                        }
                        p_tot += pp;
                        int n7 = k * 4;
                        int[] nArray = rN$array;
                        int n8 = rN$offset + n7 / 4;
                        nArray[n8] = 0;
                        ++k;
                    }
                    if (Math.abs(p_tot - 1.0) > 1.0E-7) {
                        Errors.arith_error((BytePtr)new BytePtr("rbinom: probability sum should be 1, but is %g\u0000".getBytes(), 0), (double)p_tot);
                    }
                    if (n != 0) {
                        if (n2 != 1 || p_tot != 0.0) {
                            k = 0;
                            while (n2 + -1 > k) {
                                double[] dArray = prob$array;
                                int n9 = k * 8;
                                int n10 = prob$offset + n9 / 8;
                                if (dArray[n10] != 0.0) {
                                    int iftmp$6;
                                    int n11 = k * 8;
                                    double[] dArray2 = prob$array;
                                    int n12 = prob$offset + n11 / 8;
                                    pp = dArray2[n12] / p_tot;
                                    int n13 = k * 4;
                                    int[] nArray = rN$array;
                                    int n14 = rN$offset + n13 / 4;
                                    if (pp < 1.0) {
                                        double d = n;
                                        iftmp$6 = (int)rbinom.rbinom(methodHandle, d, pp);
                                    } else {
                                        iftmp$6 = n;
                                    }
                                    nArray[n14] = iftmp$6;
                                    int n15 = k * 4;
                                    int[] nArray2 = rN$array;
                                    int n16 = rN$offset + n15 / 4;
                                    int n17 = nArray2[n16];
                                    n -= n17;
                                } else {
                                    int n18 = k * 4;
                                    int[] nArray = rN$array;
                                    int n19 = rN$offset + n18 / 4;
                                    nArray[n19] = 0;
                                }
                                if (n > 0) {
                                    int n20 = k * 8;
                                    double[] dArray3 = prob$array;
                                    int n21 = prob$offset + n20 / 8;
                                    double d = dArray3[n21];
                                    p_tot -= d;
                                    ++k;
                                    continue;
                                }
                                break block14;
                            }
                            int n22 = (n2 + -1) * 4;
                            int[] nArray = rN$array;
                            int n23 = rN$offset + n22 / 4;
                            nArray[n23] = n;
                        }
                    }
                }
            }
        }
    }
}

