/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.io;

import org.jcodings.Encoding;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyEncoding;
import org.jruby.RubyHash;
import org.jruby.RubyNumeric;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.encoding.EncodingService;
import org.jruby.util.TypeConverter;
import org.jruby.util.io.IOEncodable;
import org.jruby.util.io.InvalidValueException;
import org.jruby.util.io.ModeFlags;
import org.jruby.util.io.OpenFile;

public class EncodingUtils {
    public static final int PERM = 0;
    public static final int VMODE = 1;

    public static Encoding toEncoding(ThreadContext context, IRubyObject object) {
        if (object instanceof RubyEncoding) {
            return ((RubyEncoding)object).getEncoding();
        }
        return context.runtime.getEncodingService().getEncodingFromObject(object);
    }

    public static IRubyObject[] openArgsToArgs(Ruby runtime, IRubyObject firstElement, RubyHash options2) {
        IRubyObject value2 = EncodingUtils.hashARef(runtime, options2, "open_args");
        if (value2.isNil()) {
            return new IRubyObject[]{firstElement, options2};
        }
        RubyArray array = value2.convertToArray();
        Object[] openArgs = new IRubyObject[array.size()];
        value2.convertToArray().toArray(openArgs);
        IRubyObject[] args2 = new IRubyObject[openArgs.length + 1];
        args2[0] = firstElement;
        System.arraycopy(openArgs, 0, args2, 1, openArgs.length);
        return args2;
    }

    public static int extractBinmode(Ruby runtime, IRubyObject optionsArg, int fmode) {
        IRubyObject v = EncodingUtils.hashARef(runtime, optionsArg, "textmode");
        if (!v.isNil() && v.isTrue()) {
            fmode |= 0x1000;
        }
        if (!(v = EncodingUtils.hashARef(runtime, optionsArg, "binmode")).isNil() && v.isTrue()) {
            fmode |= 4;
        }
        if ((fmode & 4) != 0 && (fmode & 0x1000) != 0) {
            throw runtime.newArgumentError("both textmode and binmode specified");
        }
        return fmode;
    }

    private static IRubyObject hashARef(Ruby runtime, IRubyObject hash2, String symbol) {
        if (hash2 == null || !(hash2 instanceof RubyHash)) {
            return runtime.getNil();
        }
        IRubyObject value2 = ((RubyHash)hash2).fastARef(runtime.newSymbol(symbol));
        return value2 == null ? runtime.getNil() : value2;
    }

    public static Encoding ascii8bitEncoding(Ruby runtime) {
        return runtime.getEncodingService().getAscii8bitEncoding();
    }

    public static int extractModeEncoding(ThreadContext context, IOEncodable ioEncodable, IRubyObject[] pm, IRubyObject options2, boolean secondTime) {
        int fmode;
        boolean hasEncoding = false;
        int oflags = 0;
        EncodingUtils.setupReadWriteEncodings(context, ioEncodable, null, null);
        if (pm[1] == null || pm[1].isNil()) {
            fmode = 1;
            oflags = ModeFlags.RDONLY;
        } else {
            IRubyObject intMode = TypeConverter.checkIntegerType(context.runtime, pm[1], "to_int");
            if (!intMode.isNil()) {
                pm[1] = intMode;
                oflags = RubyNumeric.num2int(intMode);
                fmode = ModeFlags.getOpenFileFlagsFor(oflags);
            } else {
                String p2 = pm[1].convertToString().asJavaString();
                int colonSplit = p2.indexOf(":");
                String mode2 = colonSplit == -1 ? p2 : p2.substring(0, colonSplit);
                try {
                    fmode = OpenFile.getFModeFromString(mode2);
                    oflags = OpenFile.getModeFlagsAsIntFrom(fmode);
                }
                catch (InvalidValueException e) {
                    throw context.runtime.newArgumentError("illegal access mode " + pm[1]);
                }
                if (colonSplit != -1) {
                    hasEncoding = true;
                    EncodingUtils.parseModeEncoding(context, ioEncodable, p2.substring(colonSplit + 1));
                } else {
                    Encoding e = (fmode & 4) != 0 ? EncodingUtils.ascii8bitEncoding(context.runtime) : null;
                    EncodingUtils.setupReadWriteEncodings(context, ioEncodable, null, e);
                }
            }
        }
        if (options2 != null && !options2.isNil()) {
            IRubyObject v;
            fmode = EncodingUtils.extractBinmode(context.runtime, options2, fmode);
            oflags |= OpenFile.getModeFlagsAsIntFrom(fmode);
            if (!secondTime && !(v = EncodingUtils.hashARef(context.runtime, options2, "mode")).isNil()) {
                if (pm[1] != null && !pm[1].isNil()) {
                    throw context.runtime.newArgumentError("mode specified twice");
                }
                secondTime = true;
                pm[1] = v;
                return EncodingUtils.extractModeEncoding(context, ioEncodable, pm, options2, true);
            }
            v = EncodingUtils.hashARef(context.runtime, options2, "perm");
            if (!v.isNil() && pm[0] != null) {
                if (!pm[0].isNil()) {
                    throw context.runtime.newArgumentError("perm specified twice");
                }
                pm[0] = v;
            }
            if (EncodingUtils.getEncodingOptionFromObject(context, ioEncodable, options2) && hasEncoding) {
                throw context.runtime.newArgumentError("encoding specified twice");
            }
        }
        return oflags;
    }

    public static boolean getEncodingOptionFromObject(ThreadContext context, IOEncodable ioEncodable, IRubyObject options2) {
        if (options2 == null || options2.isNil()) {
            return false;
        }
        if (!((options2 = TypeConverter.checkHashType(context.runtime, options2)) instanceof RubyHash)) {
            throw context.runtime.newArgumentError("wrong number of arguments (3 for 1..2)");
        }
        RubyHash opts = (RubyHash)options2;
        boolean extracted = false;
        Encoding externalEncoding = null;
        Ruby runtime = options2.getRuntime();
        IRubyObject encodingOpt = opts.fastARef(runtime.newSymbol("encoding"));
        IRubyObject externalOpt = opts.fastARef(runtime.newSymbol("external_encoding"));
        IRubyObject internalOpt = opts.fastARef(runtime.newSymbol("internal_encoding"));
        if (!(externalOpt == null && internalOpt == null || encodingOpt == null || encodingOpt.isNil())) {
            runtime.getWarnings().warn("Ignoring encoding parameter '" + encodingOpt + "': " + (externalOpt == null ? "internal" : "external") + "_encoding is used");
            encodingOpt = null;
        }
        if (externalOpt != null && !externalOpt.isNil()) {
            externalEncoding = EncodingUtils.toEncoding(context, externalOpt);
        }
        Encoding internalEncoding = null;
        if (internalOpt != null && externalEncoding == (internalEncoding = internalOpt.isNil() || internalOpt.asString().toString().equals("-") ? null : EncodingUtils.toEncoding(context, internalOpt))) {
            internalEncoding = null;
        }
        if (encodingOpt != null && !encodingOpt.isNil()) {
            extracted = true;
            IRubyObject tmp = encodingOpt.checkStringType19();
            if (!tmp.isNil()) {
                EncodingUtils.parseModeEncoding(context, ioEncodable, tmp.convertToString().toString());
            } else {
                EncodingUtils.setupReadWriteEncodings(context, ioEncodable, null, EncodingUtils.toEncoding(context, encodingOpt));
            }
        } else if (externalOpt != null || internalEncoding != null) {
            extracted = true;
            EncodingUtils.setupReadWriteEncodings(context, ioEncodable, internalEncoding, externalEncoding);
        }
        return extracted;
    }

    public static void setupReadWriteEncodings(ThreadContext context, IOEncodable encodable, Encoding internal, Encoding external) {
        boolean defaultExternal = false;
        if (external == null) {
            external = context.runtime.getDefaultExternalEncoding();
            defaultExternal = true;
        }
        if (internal == null && external != EncodingUtils.ascii8bitEncoding(context.runtime)) {
            internal = context.runtime.getDefaultInternalEncoding();
        }
        if (internal == null || internal == external) {
            encodable.setReadEncoding((Encoding)(defaultExternal && internal != external ? null : external));
            encodable.setWriteEncoding(null);
        } else {
            encodable.setReadEncoding(internal);
            encodable.setWriteEncoding(external);
        }
    }

    public static void parseModeEncoding(ThreadContext context, IOEncodable ioEncodable, String option) {
        Ruby runtime = context.runtime;
        EncodingService service = runtime.getEncodingService();
        Encoding intEncoding = null;
        String[] encs = option.split(":", 2);
        if (encs[0].toLowerCase().startsWith("bom|utf-")) {
            ioEncodable.setBOM(true);
            encs[0] = encs[0].substring(4);
        }
        Encoding extEncoding = service.getEncodingFromString(encs[0]);
        if (encs.length > 1 && !encs[1].equals("-")) {
            intEncoding = service.getEncodingFromString(encs[1]);
        }
        EncodingUtils.setupReadWriteEncodings(context, ioEncodable, intEncoding, extEncoding);
    }
}

