/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.labelscan;

import org.neo4j.kernel.api.impl.index.builder.AbstractLuceneIndexBuilder;
import org.neo4j.kernel.api.impl.labelscan.LabelScanIndex;
import org.neo4j.kernel.api.impl.labelscan.ReadOnlyDatabaseLabelScanIndex;
import org.neo4j.kernel.api.impl.labelscan.WritableDatabaseLabelScanIndex;
import org.neo4j.kernel.api.impl.labelscan.storestrategy.BitmapDocumentFormat;

public class LuceneLabelScanIndexBuilder
extends AbstractLuceneIndexBuilder<LuceneLabelScanIndexBuilder> {
    public static final String DEFAULT_INDEX_IDENTIFIER = "labelStore";
    private BitmapDocumentFormat format = BitmapDocumentFormat._32;

    private LuceneLabelScanIndexBuilder() {
        this.storageBuilder.withIndexIdentifier(DEFAULT_INDEX_IDENTIFIER);
    }

    public static LuceneLabelScanIndexBuilder create() {
        return new LuceneLabelScanIndexBuilder();
    }

    public LuceneLabelScanIndexBuilder withDocumentFormat(BitmapDocumentFormat format) {
        this.format = format;
        return this;
    }

    public LabelScanIndex build() {
        return this.isReadOnly() ? new ReadOnlyDatabaseLabelScanIndex(this.format, this.storageBuilder.build()) : this.buildWritable();
    }

    public LabelScanIndex buildWritable() {
        return new WritableDatabaseLabelScanIndex(this.format, this.storageBuilder.build());
    }
}

