/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.labelscan;

import java.io.File;
import java.io.IOException;
import org.apache.lucene.store.LockObtainFailedException;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.kernel.api.impl.labelscan.LabelScanIndex;
import org.neo4j.kernel.api.impl.labelscan.LuceneLabelScanIndexBuilder;
import org.neo4j.kernel.api.labelscan.AllEntriesLabelScanReader;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.api.labelscan.LabelScanWriter;
import org.neo4j.kernel.impl.api.scan.FullStoreChangeStream;
import org.neo4j.kernel.impl.api.scan.LabelScanStoreProvider;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.storageengine.api.schema.LabelScanReader;

public class LuceneLabelScanStore
implements LabelScanStore {
    private final LuceneLabelScanIndexBuilder indexBuilder;
    private volatile LabelScanIndex luceneIndex;
    private final FullStoreChangeStream fullStoreStream;
    private final LabelScanStore.Monitor monitor;
    private boolean needsRebuild;
    private boolean switchBackToReadOnly;

    public LuceneLabelScanStore(LuceneLabelScanIndexBuilder indexBuilder, FullStoreChangeStream fullStoreStream, LabelScanStore.Monitor monitor) {
        this.indexBuilder = indexBuilder;
        this.luceneIndex = indexBuilder.build();
        this.fullStoreStream = fullStoreStream;
        this.monitor = monitor;
    }

    public void force(IOLimiter limiter) {
        try {
            if (this.luceneIndex.isOpen()) {
                this.luceneIndex.flush();
            }
        }
        catch (IOException e) {
            throw new UnderlyingStorageException((Throwable)e);
        }
    }

    public AllEntriesLabelScanReader allNodeLabelRanges() {
        return this.luceneIndex.allNodeLabelRanges();
    }

    public LabelScanReader newReader() {
        return this.luceneIndex.getLabelScanReader();
    }

    public ResourceIterator<File> snapshotStoreFiles() throws IOException {
        return this.luceneIndex.snapshot();
    }

    public void drop() throws IOException {
        this.luceneIndex.drop();
    }

    public void init() throws IOException {
        this.monitor.init();
        try {
            if (!this.hasStore()) {
                this.monitor.noIndex();
                this.create();
                this.needsRebuild = true;
            } else if (!this.luceneIndex.isValid()) {
                this.monitor.notValidIndex();
                this.drop();
                this.luceneIndex.create();
                this.needsRebuild = true;
            }
            this.luceneIndex.open();
        }
        catch (LockObtainFailedException e) {
            this.luceneIndex.close();
            this.monitor.lockedIndex((Exception)((Object)e));
            throw e;
        }
    }

    private void create() throws IOException {
        if (this.luceneIndex.isReadOnly()) {
            this.luceneIndex.close();
            this.luceneIndex = this.indexBuilder.buildWritable();
            this.luceneIndex.create();
            this.switchBackToReadOnly = true;
        }
    }

    public void start() throws IOException {
        if (this.needsRebuild) {
            this.monitor.rebuilding();
            long numberOfNodes = LabelScanStoreProvider.rebuild((LabelScanStore)this, (FullStoreChangeStream)this.fullStoreStream);
            this.monitor.rebuilt(numberOfNodes);
            this.needsRebuild = false;
        }
        if (this.switchBackToReadOnly) {
            this.luceneIndex.close();
            this.luceneIndex = this.indexBuilder.build();
            this.luceneIndex.open();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isEmpty() throws IOException {
        try (AllEntriesLabelScanReader allEntries = this.allNodeLabelRanges();){
            boolean bl = allEntries.maxCount() == 0L;
            return bl;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public void stop() {
    }

    public void shutdown() throws IOException {
        this.luceneIndex.close();
    }

    public LabelScanWriter newWriter() {
        return this.luceneIndex.getLabelScanWriter();
    }

    public boolean isReadOnly() {
        return this.luceneIndex.isReadOnly();
    }

    public boolean hasStore() throws IOException {
        return this.luceneIndex.exists();
    }
}

