/*
 * Decompiled with CFR 0.152.
 */
package org.jxmpp.util;

import org.jxmpp.util.cache.LruCache;

public class XmppStringUtils {
    private static final LruCache<String, String> LOCALPART_ESACPE_CACHE = new LruCache(100);
    private static final LruCache<String, String> LOCALPART_UNESCAPE_CACHE = new LruCache(100);

    public static String parseLocalpart(String jid) {
        int atIndex = jid.indexOf(64);
        if (atIndex <= 0) {
            return "";
        }
        int slashIndex = jid.indexOf(47);
        if (slashIndex >= 0 && slashIndex < atIndex) {
            return "";
        }
        return jid.substring(0, atIndex);
    }

    public static String parseDomain(String jid) {
        int atIndex = jid.indexOf(64);
        if (atIndex + 1 > jid.length()) {
            return "";
        }
        int slashIndex = jid.indexOf(47);
        if (slashIndex > 0) {
            if (slashIndex > atIndex) {
                return jid.substring(atIndex + 1, slashIndex);
            }
            return jid.substring(0, slashIndex);
        }
        return jid.substring(atIndex + 1);
    }

    public static String parseResource(String jid) {
        int slashIndex = jid.indexOf(47);
        if (slashIndex + 1 > jid.length() || slashIndex < 0) {
            return "";
        }
        return jid.substring(slashIndex + 1);
    }

    @Deprecated
    public static String parseBareAddress(String jid) {
        return XmppStringUtils.parseBareJid(jid);
    }

    public static String parseBareJid(String jid) {
        int slashIndex = jid.indexOf(47);
        if (slashIndex < 0) {
            return jid;
        }
        if (slashIndex == 0) {
            return "";
        }
        return jid.substring(0, slashIndex);
    }

    public static boolean isFullJID(String jid) {
        return XmppStringUtils.parseLocalpart(jid).length() > 0 && XmppStringUtils.parseDomain(jid).length() > 0 && XmppStringUtils.parseResource(jid).length() > 0;
    }

    public static boolean isBareJid(String jid) {
        return XmppStringUtils.parseLocalpart(jid).length() > 0 && XmppStringUtils.parseDomain(jid).length() > 0 && XmppStringUtils.parseResource(jid).length() == 0;
    }

    public static String escapeLocalpart(String localpart) {
        if (localpart == null) {
            return null;
        }
        String res = (String)LOCALPART_ESACPE_CACHE.get((Object)localpart);
        if (res != null) {
            return res;
        }
        StringBuilder buf = new StringBuilder(localpart.length() + 8);
        int n = localpart.length();
        block11: for (int i = 0; i < n; ++i) {
            char c = localpart.charAt(i);
            switch (c) {
                case '\"': {
                    buf.append("\\22");
                    continue block11;
                }
                case '&': {
                    buf.append("\\26");
                    continue block11;
                }
                case '\'': {
                    buf.append("\\27");
                    continue block11;
                }
                case '/': {
                    buf.append("\\2f");
                    continue block11;
                }
                case ':': {
                    buf.append("\\3a");
                    continue block11;
                }
                case '<': {
                    buf.append("\\3c");
                    continue block11;
                }
                case '>': {
                    buf.append("\\3e");
                    continue block11;
                }
                case '@': {
                    buf.append("\\40");
                    continue block11;
                }
                case '\\': {
                    buf.append("\\5c");
                    continue block11;
                }
                default: {
                    if (Character.isWhitespace(c)) {
                        buf.append("\\20");
                        continue block11;
                    }
                    buf.append(c);
                }
            }
        }
        res = buf.toString();
        LOCALPART_ESACPE_CACHE.put((Object)localpart, (Object)res);
        return res;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String unescapeLocalpart(String localpart) {
        if (localpart == null) {
            return null;
        }
        String res = (String)LOCALPART_UNESCAPE_CACHE.get((Object)localpart);
        if (res != null) {
            return res;
        }
        char[] localpartChars = localpart.toCharArray();
        StringBuilder buf = new StringBuilder(localpartChars.length);
        int i = 0;
        int n = localpartChars.length;
        while (true) {
            block23: {
                char c;
                block22: {
                    if (i >= n) {
                        res = buf.toString();
                        LOCALPART_UNESCAPE_CACHE.put((Object)localpart, (Object)res);
                        return res;
                    }
                    c = localpart.charAt(i);
                    if (c != '\\' || i + 2 >= n) break block22;
                    char c2 = localpartChars[i + 1];
                    char c3 = localpartChars[i + 2];
                    switch (c2) {
                        case '2': {
                            switch (c3) {
                                case '0': {
                                    buf.append(' ');
                                    i += 2;
                                    break block23;
                                }
                                case '2': {
                                    buf.append('\"');
                                    i += 2;
                                    break block23;
                                }
                                case '6': {
                                    buf.append('&');
                                    i += 2;
                                    break block23;
                                }
                                case '7': {
                                    buf.append('\'');
                                    i += 2;
                                    break block23;
                                }
                                case 'f': {
                                    buf.append('/');
                                    i += 2;
                                    break block23;
                                }
                            }
                            break;
                        }
                        case '3': {
                            switch (c3) {
                                case 'a': {
                                    buf.append(':');
                                    i += 2;
                                    break block23;
                                }
                                case 'c': {
                                    buf.append('<');
                                    i += 2;
                                    break block23;
                                }
                                case 'e': {
                                    buf.append('>');
                                    i += 2;
                                    break block23;
                                }
                            }
                            break;
                        }
                        case '4': {
                            if (c3 != '0') break;
                            buf.append("@");
                            i += 2;
                            break block23;
                        }
                        case '5': {
                            if (c3 != 'c') break;
                            buf.append("\\");
                            i += 2;
                            break block23;
                        }
                    }
                }
                buf.append(c);
            }
            ++i;
        }
    }

    public static String completeJidFrom(CharSequence localpart, CharSequence domainpart) {
        return XmppStringUtils.completeJidFrom(localpart != null ? localpart.toString() : null, domainpart.toString());
    }

    public static String completeJidFrom(String localpart, String domainpart) {
        return XmppStringUtils.completeJidFrom(localpart, domainpart, null);
    }

    public static String completeJidFrom(CharSequence localpart, CharSequence domainpart, CharSequence resource) {
        return XmppStringUtils.completeJidFrom(localpart != null ? localpart.toString() : null, domainpart.toString(), resource != null ? resource.toString() : null);
    }

    public static String completeJidFrom(String localpart, String domainpart, String resource) {
        if (domainpart == null) {
            throw new IllegalArgumentException("domainpart must not be null");
        }
        int localpartLength = localpart != null ? localpart.length() : 0;
        int domainpartLength = domainpart.length();
        int resourceLength = resource != null ? resource.length() : 0;
        int maxResLength = localpartLength + domainpartLength + resourceLength + 2;
        StringBuilder sb = new StringBuilder(maxResLength);
        if (localpartLength > 0) {
            sb.append(localpart).append('@');
        }
        sb.append(domainpart);
        if (resourceLength > 0) {
            sb.append('/').append(resource);
        }
        return sb.toString();
    }

    public static String generateKey(String element, String namespace) {
        return element + '\t' + namespace;
    }
}

