/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.io.wkt;

import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Locale;
import java.util.Map;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Length;
import javax.measure.quantity.Quantity;
import javax.measure.unit.BaseUnit;
import javax.measure.unit.NonSI;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import javax.measure.unit.UnitFormat;
import org.apache.sis.internal.metadata.AxisDirections;
import org.apache.sis.internal.metadata.ReferencingServices;
import org.apache.sis.internal.metadata.VerticalDatumTypes;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.internal.util.LocalizedParseException;
import org.apache.sis.io.wkt.Convention;
import org.apache.sis.io.wkt.Element;
import org.apache.sis.io.wkt.MathTransformParser;
import org.apache.sis.io.wkt.Symbols;
import org.apache.sis.io.wkt.Transliterator;
import org.apache.sis.io.wkt.VerticalInfo;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.iso.ImmutableIdentifier;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.metadata.iso.extent.DefaultExtent;
import org.apache.sis.metadata.iso.extent.DefaultGeographicBoundingBox;
import org.apache.sis.metadata.iso.extent.DefaultGeographicDescription;
import org.apache.sis.metadata.iso.extent.DefaultTemporalExtent;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.iso.Types;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.Identifier;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ObjectFactory;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.DerivedCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ImageCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CSFactory;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.DatumFactory;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.EngineeringDatum;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.ImageDatum;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.datum.VerticalDatumType;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.Factory;
import org.opengis.util.FactoryException;

final class GeodeticObjectParser
extends MathTransformParser
implements Comparator<CoordinateSystemAxis> {
    private static final String[] ToWGS84 = new String[]{"dx", "dy", "dz", "ex", "ey", "ez", "ppm"};
    private final CRSFactory crsFactory;
    private final CSFactory csFactory;
    private final DatumFactory datumFactory;
    private final CoordinateOperationFactory opFactory;
    private final ReferencingServices referencing;
    private final boolean usesCommonUnits;
    private final boolean ignoreAxes;
    private final Transliterator transliterator;
    private final Map<String, Object> properties = new HashMap<String, Object>(4);
    private final Map<CoordinateSystemAxis, Integer> axisOrder = new IdentityHashMap<CoordinateSystemAxis, Integer>(4);
    private transient VerticalCRS verticalCRS;
    private transient VerticalInfo verticalElements;

    public GeodeticObjectParser(Map<String, ?> map, ObjectFactory objectFactory, MathTransformFactory mathTransformFactory) {
        super(Symbols.getDefault(), Collections.<String, Element>emptyMap(), null, null, null, mathTransformFactory, (Locale)map.get("locale"));
        this.crsFactory = (CRSFactory)objectFactory;
        this.csFactory = (CSFactory)objectFactory;
        this.datumFactory = (DatumFactory)objectFactory;
        this.referencing = ReferencingServices.getInstance();
        this.opFactory = this.referencing.getCoordinateOperationFactory(map, mathTransformFactory);
        this.transliterator = Transliterator.DEFAULT;
        this.usesCommonUnits = false;
        this.ignoreAxes = false;
    }

    GeodeticObjectParser(Symbols symbols, Map<String, Element> map, NumberFormat numberFormat, DateFormat dateFormat, UnitFormat unitFormat, Convention convention, Transliterator transliterator, Locale locale, Map<Class<?>, Factory> map2) {
        super(symbols, map, numberFormat, dateFormat, unitFormat, GeodeticObjectParser.getFactory(MathTransformFactory.class, map2), locale);
        this.transliterator = transliterator;
        this.crsFactory = GeodeticObjectParser.getFactory(CRSFactory.class, map2);
        this.csFactory = GeodeticObjectParser.getFactory(CSFactory.class, map2);
        this.datumFactory = GeodeticObjectParser.getFactory(DatumFactory.class, map2);
        this.referencing = ReferencingServices.getInstance();
        this.usesCommonUnits = convention.usesCommonUnits;
        this.ignoreAxes = convention == Convention.WKT1_IGNORE_AXES;
        Factory factory = map2.get(CoordinateOperationFactory.class);
        if (factory != null) {
            this.opFactory = (CoordinateOperationFactory)factory;
        } else {
            this.opFactory = this.referencing.getCoordinateOperationFactory(null, this.mtFactory);
            map2.put(CoordinateOperationFactory.class, this.opFactory);
        }
    }

    static <T extends Factory> T getFactory(Class<T> clazz, Map<Class<?>, Factory> map) {
        Factory factory = (Factory)clazz.cast(map.get(clazz));
        if (factory == null) {
            factory = (Factory)DefaultFactories.forBuildin(clazz);
            map.put(clazz, factory);
        }
        return (T)factory;
    }

    @Override
    String getPublicFacade() {
        return "org.apache.sis.referencing.factory.GeodeticObjectFactory";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object parseObject(String string, ParsePosition parsePosition) throws ParseException {
        Object object;
        block9: {
            try {
                Exception exception;
                block10: {
                    object = super.parseObject(string, parsePosition);
                    if (this.verticalElements == null) break block9;
                    exception = null;
                    try {
                        this.verticalElements = this.verticalElements.resolve(this.referencing.getMSLH());
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        exception = unsupportedOperationException;
                    }
                    if (this.verticalElements != null) {
                        try {
                            this.verticalElements = this.verticalElements.complete(this.crsFactory, this.csFactory);
                        }
                        catch (FactoryException factoryException) {
                            if (exception != null) break block10;
                            exception = factoryException;
                        }
                    }
                }
                if (this.verticalElements != null) {
                    this.warning(Errors.formatInternational((short)168, "VerticalExtent", this.verticalElements.unit), exception);
                }
            }
            finally {
                this.verticalElements = null;
                this.verticalCRS = null;
                this.axisOrder.clear();
                this.properties.clear();
            }
        }
        return object;
    }

    @Override
    Object parseObject(Element element) throws ParseException {
        Object object = this.parseCoordinateReferenceSystem(element, false);
        if (object != null) {
            return object;
        }
        object = this.parseMathTransform(element, false);
        if (object != null) {
            return object;
        }
        Object object2 = this.parseAxis(0, element, null, (Unit<?>)SI.METRE);
        if (object2 == null && (object2 = this.parsePrimeMeridian(0, element, false, (Unit<Angle>)NonSI.DEGREE_ANGLE)) == null && (object2 = this.parseDatum(0, element, null)) == null && (object2 = this.parseEllipsoid(0, element)) == null && (object2 = this.parseToWGS84(0, element)) == null && (object2 = this.parseVerticalDatum(0, element, false)) == null && (object2 = this.parseTimeDatum(0, element)) == null && (object2 = this.parseEngineeringDatum(0, element, false)) == null && (object2 = this.parseImageDatum(0, element)) == null && (object2 = this.parseOperation(0, element)) == null) {
            throw element.missingOrUnknownComponent("GeodeticCRS");
        }
        return object2;
    }

    private CoordinateReferenceSystem parseCoordinateReferenceSystem(Element element, boolean bl) throws ParseException {
        CoordinateReferenceSystem coordinateReferenceSystem = this.parseGeodeticCRS(0, element, 2, null);
        if (coordinateReferenceSystem == null && (coordinateReferenceSystem = this.parseProjectedCRS(0, element, false)) == null && (coordinateReferenceSystem = this.parseVerticalCRS(0, element, false)) == null && (coordinateReferenceSystem = this.parseTimeCRS(0, element, false)) == null && (coordinateReferenceSystem = this.parseEngineeringCRS(0, element, false)) == null && (coordinateReferenceSystem = this.parseImageCRS(0, element)) == null && (coordinateReferenceSystem = this.parseCompoundCRS(0, element)) == null && (coordinateReferenceSystem = this.parseFittedCS(0, element)) == null && bl) {
            throw element.missingOrUnknownComponent("GeodeticCRS");
        }
        return coordinateReferenceSystem;
    }

    private CoordinateReferenceSystem parseCoordinateReferenceSystem(Element element, int n, String string) throws ParseException {
        Element element2 = element.pullElement(n, string);
        if (element2 == null) {
            return null;
        }
        CoordinateReferenceSystem coordinateReferenceSystem = this.parseCoordinateReferenceSystem(element2, true);
        element2.close(this.ignoredElements);
        return coordinateReferenceSystem;
    }

    private static Identifier toIdentifier(Object object) {
        return object instanceof Identifier[] ? ((Identifier[])object)[0] : (Identifier)object;
    }

    private Map<String, Object> parseMetadataAndClose(Element element, String string, IdentifiedObject identifiedObject) throws ParseException {
        Object object;
        String string2;
        Object object2;
        Element element2;
        this.properties.clear();
        this.properties.put("name", string.isEmpty() && identifiedObject != null ? identifiedObject.getName() : string);
        while ((element2 = element.pullElement(1, ID_KEYWORDS)) != null) {
            Identifier[] identifierArray;
            String string3;
            object2 = element2.pullString("codeSpace");
            string2 = element2.pullObject("code").toString();
            object = element2.pullOptional(Object.class);
            Element element3 = element2.pullElement(1, "Citation");
            if (element3 != null) {
                string3 = element3.pullString("authority");
                element3.close(this.ignoredElements);
            } else {
                string3 = object2;
            }
            Element element4 = element2.pullElement(1, "URI");
            if (element4 != null) {
                element4.pullString("URI");
                element4.close(this.ignoredElements);
            }
            element2.close(this.ignoredElements);
            ImmutableIdentifier immutableIdentifier = new ImmutableIdentifier(Citations.fromName(string3), (String)object2, string2, object != null ? object.toString() : null, null);
            Object object3 = this.properties.put("identifiers", immutableIdentifier);
            if (object3 == null) continue;
            if (object3 instanceof Identifier) {
                identifierArray = new Identifier[]{(Identifier)object3, immutableIdentifier};
            } else {
                identifierArray = (Identifier[])object3;
                int n = identifierArray.length;
                identifierArray = Arrays.copyOf(identifierArray, n + 1);
                identifierArray[n] = immutableIdentifier;
            }
            this.properties.put("identifiers", identifierArray);
        }
        if (!element.isEmpty()) {
            element2 = element.pullElement(1, "Scope");
            if (element2 != null) {
                this.properties.put("scope", element2.pullString("scope"));
                element2.close(this.ignoredElements);
            }
            object2 = null;
            while ((element2 = element.pullElement(1, "Area")) != null) {
                string2 = element2.pullString("area");
                element2.close(this.ignoredElements);
                if (object2 == null) {
                    object2 = new DefaultExtent();
                }
                ((DefaultExtent)object2).getGeographicElements().add(new DefaultGeographicDescription(string2));
            }
            while ((element2 = element.pullElement(1, "BBox")) != null) {
                double d = element2.pullDouble("southBoundLatitude");
                double d2 = element2.pullDouble("westBoundLongitude");
                double d3 = element2.pullDouble("northBoundLatitude");
                double d4 = element2.pullDouble("eastBoundLongitude");
                element2.close(this.ignoredElements);
                if (object2 == null) {
                    object2 = new DefaultExtent();
                }
                ((DefaultExtent)object2).getGeographicElements().add(new DefaultGeographicBoundingBox(d2, d4, d, d3));
            }
            while ((element2 = element.pullElement(1, "VerticalExtent")) != null) {
                double d = element2.pullDouble("minimum");
                double d5 = element2.pullDouble("maximum");
                BaseUnit baseUnit = this.parseScaledUnit(element2, "LengthUnit", (Unit)SI.METRE);
                element2.close(this.ignoredElements);
                if (baseUnit == null) {
                    baseUnit = SI.METRE;
                }
                if (object2 == null) {
                    object2 = new DefaultExtent();
                }
                this.verticalElements = new VerticalInfo(this.verticalElements, (DefaultExtent)object2, d, d5, (Unit<Length>)baseUnit).resolve(this.verticalCRS);
            }
            while ((element2 = element.pullElement(1, "TimeExtent")) != null) {
                if (element2.peekValue() instanceof String) {
                    element2.pullString("startTime");
                    element2.pullString("endTime");
                    element2.close(this.ignoredElements);
                    this.warning(Errors.formatInternational((short)129, (Object)"TimeExtent[String,String]"), null);
                    continue;
                }
                Date date = element2.pullDate("startTime");
                object = element2.pullDate("endTime");
                element2.close(this.ignoredElements);
                try {
                    DefaultTemporalExtent defaultTemporalExtent = new DefaultTemporalExtent();
                    defaultTemporalExtent.setBounds(date, (Date)object);
                    if (object2 == null) {
                        object2 = new DefaultExtent();
                    }
                    ((DefaultExtent)object2).getTemporalElements().add(defaultTemporalExtent);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    this.warning(element, element2, unsupportedOperationException);
                }
            }
            element2 = element.pullElement(1, "Remark");
            if (element2 != null) {
                this.properties.put("remarks", element2.pullString("remarks"));
                element2.close(this.ignoredElements);
            }
        }
        element.close(this.ignoredElements);
        return this.properties;
    }

    private Map<String, Object> parseAnchorAndClose(Element element, String string) throws ParseException {
        Element element2 = element.pullElement(1, "Anchor");
        Map<String, Object> map = this.parseMetadataAndClose(element, string, null);
        if (element2 != null) {
            map.put("anchorPoint", element2.pullString("anchorDefinition"));
            element2.close(this.ignoredElements);
        }
        return map;
    }

    private <Q extends Quantity> Unit<Q> parseScaledUnit(Element element, String string, Unit<Q> unit) throws ParseException {
        Element element2 = element.pullElement(1, string, "Unit");
        if (element2 == null) {
            return null;
        }
        String string2 = element2.pullString("name");
        double d = element2.pullDouble("factor");
        Unit<?> unit2 = this.parseUnitID(element2);
        element2.close(this.ignoredElements);
        if (unit2 != null) {
            if (unit.toSI().equals((Object)unit2.toSI())) {
                return unit2;
            }
            this.warning(Errors.formatInternational((short)43, string, unit2), null);
        }
        return Units.multiply(unit, d);
    }

    private CoordinateSystem parseCoordinateSystem(Element element, String string, int n, boolean bl, Unit<?> baseUnit, Datum datum) throws ParseException, FactoryException {
        CharSequence charSequence;
        Object object;
        Object object2;
        CoordinateSystemAxis[] coordinateSystemAxisArray;
        this.axisOrder.clear();
        boolean bl2 = n >= 3;
        Map<String, Object> map = null;
        if (!bl && (coordinateSystemAxisArray = element.pullElement(1, "CS")) != null) {
            object2 = string;
            string = coordinateSystemAxisArray.pullVoidElement((String)"type").keyword;
            n = coordinateSystemAxisArray.pullInteger("dimension");
            map = new HashMap<String, Object>(this.parseMetadataAndClose((Element)coordinateSystemAxisArray, "CS", null));
            if (object2 != null && !((String)object2).equalsIgnoreCase(string)) {
                throw new LocalizedParseException(this.errorLocale, 191, new String[]{"CS", string}, coordinateSystemAxisArray.offset);
            }
            if (n <= 0 || n > 1000) {
                Object[] objectArray;
                short s;
                if (n <= 0) {
                    s = 132;
                    objectArray = new Object[]{"dimension", n};
                } else {
                    s = 177;
                    objectArray = new Object[]{n};
                }
                throw new LocalizedParseException(this.errorLocale, s, objectArray, coordinateSystemAxisArray.offset);
            }
            string = string.equalsIgnoreCase("Cartesian") ? "Cartesian" : string.toLowerCase(this.symbols.getLocale());
        }
        coordinateSystemAxisArray = null;
        object2 = this.parseAxis(string == null ? 2 : 1, element, string, (Unit<?>)baseUnit);
        if (object2 != null) {
            object = new ArrayList<Object>(n + 2);
            do {
                object.add(object2);
            } while ((object2 = this.parseAxis(object.size() < n ? 2 : 1, element, string, (Unit<?>)baseUnit)) != null);
            if (!bl || !this.ignoreAxes) {
                coordinateSystemAxisArray = object.toArray(new CoordinateSystemAxis[object.size()]);
                Arrays.sort(coordinateSystemAxisArray, this);
            }
        }
        if (coordinateSystemAxisArray == null) {
            if (string == null) {
                throw element.missingComponent("Axis");
            }
            object = null;
            charSequence = null;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            AxisDirection axisDirection = AxisDirection.EAST;
            AxisDirection axisDirection2 = AxisDirection.NORTH;
            AxisDirection axisDirection3 = null;
            BaseUnit baseUnit2 = baseUnit;
            if (string.equals("Cartesian")) {
                if (!(datum instanceof GeodeticDatum)) {
                    throw element.missingComponent("Axis");
                }
                if (baseUnit == null) {
                    throw element.missingComponent("LengthUnit");
                }
                if (bl2) {
                    return this.referencing.getGeocentricCS((Unit<Length>)baseUnit.asType(Length.class));
                }
                object = "Easting";
                charSequence = "E";
                string2 = "Northing";
                string3 = "N";
                if (n >= 3) {
                    string5 = "h";
                    string4 = "Ellipsoidal height";
                    baseUnit2 = SI.METRE;
                }
            } else if (string.equals("ellipsoidal")) {
                if (baseUnit == null) {
                    throw element.missingComponent("AngleUnit");
                }
                if (bl) {
                    object = "Geodetic longitude";
                    charSequence = "\u03bb";
                    string2 = "Geodetic latitude";
                    string3 = "\u03c6";
                } else {
                    object = "Geodetic latitude";
                    charSequence = "\u03c6";
                    axisDirection = AxisDirection.NORTH;
                    string2 = "Geodetic longitude";
                    string3 = "\u03bb";
                    axisDirection2 = AxisDirection.EAST;
                }
                if (n >= 3) {
                    axisDirection3 = AxisDirection.UP;
                    string5 = "h";
                    string4 = "Ellipsoidal height";
                    baseUnit2 = SI.METRE;
                }
            } else if (string.equals("vertical")) {
                if (baseUnit == null) {
                    throw element.missingComponent("Unit");
                }
                string5 = "h";
                string4 = "Height";
                axisDirection3 = AxisDirection.UP;
                if (datum instanceof VerticalDatum) {
                    VerticalDatumType verticalDatumType = ((VerticalDatum)datum).getVerticalDatumType();
                    if (VerticalDatumType.GEOIDAL.equals(verticalDatumType)) {
                        string4 = "Gravity-related height";
                        string5 = "H";
                    } else if (VerticalDatumType.DEPTH.equals(verticalDatumType)) {
                        axisDirection3 = AxisDirection.DOWN;
                        string4 = "Depth";
                        string5 = "D";
                    } else if (VerticalDatumTypes.ELLIPSOIDAL.equals(verticalDatumType)) {
                        string4 = "Ellipsoidal height";
                    }
                }
            } else if (string.equals("temporal")) {
                if (baseUnit == null) {
                    throw element.missingComponent("TimeUnit");
                }
                axisDirection3 = AxisDirection.FUTURE;
                string4 = "Time";
                string5 = "t";
            } else {
                throw element.missingComponent("Axis");
            }
            int n2 = 0;
            coordinateSystemAxisArray = new CoordinateSystemAxis[n];
            if (charSequence != null && n2 < n) {
                coordinateSystemAxisArray[n2++] = this.csFactory.createCoordinateSystemAxis(Collections.singletonMap("name", object), (String)charSequence, axisDirection, (Unit<?>)baseUnit);
            }
            if (string3 != null && n2 < n) {
                coordinateSystemAxisArray[n2++] = this.csFactory.createCoordinateSystemAxis(Collections.singletonMap("name", string2), string3, axisDirection2, (Unit<?>)baseUnit);
            }
            if (string5 != null && n2 < n) {
                coordinateSystemAxisArray[n2++] = this.csFactory.createCoordinateSystemAxis(Collections.singletonMap("name", string4), string5, axisDirection3, (Unit<?>)baseUnit2);
            }
        }
        charSequence = new StringBuilder();
        if (string != null && !string.isEmpty()) {
            int n3 = string.codePointAt(0);
            charSequence.appendCodePoint(Character.toUpperCase(n3)).append(string, Character.charCount(n3), string.length()).append(' ');
        }
        object = AxisDirections.appendTo(charSequence.append("CS"), coordinateSystemAxisArray);
        if (map == null) {
            map = Collections.singletonMap("name", object);
        } else {
            map.put("name", object);
        }
        if (string == null) {
            return this.referencing.createAbstractCS(map, coordinateSystemAxisArray);
        }
        if (string.equals("ellipsoidal")) {
            switch (coordinateSystemAxisArray.length) {
                case 2: {
                    return this.csFactory.createEllipsoidalCS(map, coordinateSystemAxisArray[0], coordinateSystemAxisArray[1]);
                }
                case 3: {
                    return this.csFactory.createEllipsoidalCS(map, coordinateSystemAxisArray[0], coordinateSystemAxisArray[1], coordinateSystemAxisArray[2]);
                }
            }
            n = coordinateSystemAxisArray.length < 2 ? 2 : 3;
        } else if (string.equals("Cartesian")) {
            switch (coordinateSystemAxisArray.length) {
                case 2: {
                    return this.csFactory.createCartesianCS(map, coordinateSystemAxisArray[0], coordinateSystemAxisArray[1]);
                }
                case 3: {
                    return this.csFactory.createCartesianCS(map, coordinateSystemAxisArray[0], coordinateSystemAxisArray[1], coordinateSystemAxisArray[2]);
                }
            }
            n = coordinateSystemAxisArray.length < 2 ? 2 : 3;
        } else if (string.equals("affine")) {
            switch (coordinateSystemAxisArray.length) {
                case 2: {
                    return this.csFactory.createAffineCS(map, coordinateSystemAxisArray[0], coordinateSystemAxisArray[1]);
                }
                case 3: {
                    return this.csFactory.createAffineCS(map, coordinateSystemAxisArray[0], coordinateSystemAxisArray[1], coordinateSystemAxisArray[2]);
                }
            }
            n = coordinateSystemAxisArray.length < 2 ? 2 : 3;
        } else if (string.equals("vertical")) {
            n = 1;
            if (coordinateSystemAxisArray.length == 1) {
                return this.csFactory.createVerticalCS(map, coordinateSystemAxisArray[0]);
            }
        } else if (string.equals("temporal")) {
            n = 1;
            if (coordinateSystemAxisArray.length == 1) {
                return this.csFactory.createTimeCS(map, coordinateSystemAxisArray[0]);
            }
        } else if (string.equals("linear")) {
            n = 1;
            if (coordinateSystemAxisArray.length == 1) {
                return this.csFactory.createLinearCS(map, coordinateSystemAxisArray[0]);
            }
        } else if (string.equals("polar")) {
            n = 2;
            if (coordinateSystemAxisArray.length == 2) {
                return this.csFactory.createPolarCS(map, coordinateSystemAxisArray[0], coordinateSystemAxisArray[1]);
            }
        } else if (string.equals("cylindrical")) {
            n = 3;
            if (coordinateSystemAxisArray.length == 3) {
                return this.csFactory.createCylindricalCS(map, coordinateSystemAxisArray[0], coordinateSystemAxisArray[1], coordinateSystemAxisArray[2]);
            }
        } else if (string.equals("spherical")) {
            n = 3;
            if (coordinateSystemAxisArray.length == 3) {
                return this.csFactory.createSphericalCS(map, coordinateSystemAxisArray[0], coordinateSystemAxisArray[1], coordinateSystemAxisArray[2]);
            }
        } else {
            if (string.equals("parametric")) {
                return this.referencing.createAbstractCS(map, coordinateSystemAxisArray);
            }
            this.warning(Errors.formatInternational((short)118, (Object)string), null);
            return this.referencing.createAbstractCS(map, coordinateSystemAxisArray);
        }
        throw new LocalizedParseException(this.errorLocale, coordinateSystemAxisArray.length > n ? (short)149 : 148, new Object[]{n, "Axis"}, element.offset);
    }

    private CoordinateSystemAxis parseAxis(int n, Element element, String string, Unit<?> unit) throws ParseException {
        CoordinateSystemAxis coordinateSystemAxis;
        String string2;
        int n2;
        int n3;
        Element element2 = element.pullElement(n, "Axis");
        if (element2 == null) {
            return null;
        }
        String string3 = element2.pullString("name");
        Element element3 = element2.pullVoidElement("orientation");
        Unit<?> unit2 = this.parseUnit(element2);
        if (unit2 == null) {
            if (unit == null) {
                throw element2.missingComponent("Unit");
            }
            unit2 = unit;
        }
        AxisDirection axisDirection = Types.forCodeName(AxisDirection.class, element3.keyword, true);
        Element element4 = element2.pullElement(1, "Meridian");
        if (element4 != null) {
            double d = element4.pullDouble("meridian");
            Unit unit3 = this.parseScaledUnit(element4, "AngleUnit", (Unit)SI.RADIAN);
            element4.close(this.ignoredElements);
            if (unit3 != null) {
                d = unit3.getConverterTo(NonSI.DEGREE_ANGLE).convert(d);
            }
            axisDirection = this.referencing.directionAlongMeridian(axisDirection, d);
        }
        if ((n3 = string3.length() - 1) > 1 && string3.charAt(n3) == ')' && (n2 = string3.lastIndexOf(40, n3 - 1)) >= 0) {
            string2 = CharSequences.trimWhitespaces(string3.substring(n2 + 1, n3));
            if ((string3 = CharSequences.trimWhitespaces(string3.substring(0, n2))).isEmpty()) {
                string3 = string2;
            }
        } else {
            string2 = AxisDirections.suggestAbbreviation(string3, axisDirection, unit2);
        }
        string3 = this.transliterator.toLongAxisName(string, axisDirection, string3);
        string2 = this.transliterator.toUnicodeAbbreviation(string, axisDirection, string2);
        Element element5 = element2.pullElement(1, "Order");
        Integer n4 = null;
        if (element5 != null) {
            n4 = element5.pullInteger("order");
            element5.close(this.ignoredElements);
        }
        try {
            coordinateSystemAxis = this.csFactory.createCoordinateSystemAxis(this.parseMetadataAndClose(element2, string3, null), string2, axisDirection, unit2);
        }
        catch (FactoryException factoryException) {
            throw element2.parseFailed(factoryException);
        }
        if (this.axisOrder.put(coordinateSystemAxis, n4) != null) {
            throw new LocalizedParseException(this.errorLocale, 16, new Object[]{"Axis[\u201c" + string3 + "\u201d]"}, element2.offset);
        }
        return coordinateSystemAxis;
    }

    @Override
    public int compare(CoordinateSystemAxis coordinateSystemAxis, CoordinateSystemAxis coordinateSystemAxis2) {
        Integer n = this.axisOrder.get(coordinateSystemAxis);
        Integer n2 = this.axisOrder.get(coordinateSystemAxis2);
        if (n != null) {
            if (n2 != null) {
                return n - n2;
            }
            return -1;
        }
        if (n2 != null) {
            return 1;
        }
        return 0;
    }

    private PrimeMeridian parsePrimeMeridian(int n, Element element, boolean bl, Unit<Angle> unit) throws ParseException {
        Element element2;
        if (bl && this.usesCommonUnits) {
            unit = NonSI.DEGREE_ANGLE;
        }
        if ((element2 = element.pullElement(n, "PrimeMeridian", "PrimeM")) == null) {
            return null;
        }
        String string = element2.pullString("name");
        double d = element2.pullDouble("longitude");
        Unit unit2 = this.parseScaledUnit(element2, "AngleUnit", (Unit)SI.RADIAN);
        if (unit2 != null) {
            unit = unit2;
        } else if (unit == null) {
            throw element.missingComponent("AngleUnit");
        }
        try {
            return this.datumFactory.createPrimeMeridian(this.parseMetadataAndClose(element2, string, null), d, unit);
        }
        catch (FactoryException factoryException) {
            throw element2.parseFailed(factoryException);
        }
    }

    private Object parseToWGS84(int n, Element element) throws ParseException {
        Element element2 = element.pullElement(n, "ToWGS84");
        if (element2 == null) {
            return null;
        }
        double[] dArray = new double[ToWGS84.length];
        int n2 = 0;
        while (n2 < dArray.length) {
            dArray[n2] = element2.pullDouble(ToWGS84[n2]);
            if (++n2 % 3 != 0 || !element2.isEmpty()) continue;
        }
        element2.close(this.ignoredElements);
        return this.referencing.createToWGS84(dArray);
    }

    private Ellipsoid parseEllipsoid(int n, Element element) throws ParseException {
        Element element2 = element.pullElement(n, "Ellipsoid", "Spheroid");
        if (element2 == null) {
            return null;
        }
        String string = element2.pullString("name");
        double d = element2.pullDouble("semiMajorAxis");
        double d2 = element2.pullDouble("inverseFlattening");
        BaseUnit baseUnit = this.parseScaledUnit(element2, "LengthUnit", (Unit)SI.METRE);
        if (baseUnit == null) {
            baseUnit = SI.METRE;
        }
        Map<String, Object> map = this.parseMetadataAndClose(element2, string, null);
        try {
            if (d2 == 0.0) {
                return this.datumFactory.createEllipsoid(map, d, d, (Unit<Length>)baseUnit);
            }
            return this.datumFactory.createFlattenedSphere(map, d, d2, (Unit<Length>)baseUnit);
        }
        catch (FactoryException factoryException) {
            throw element2.parseFailed(factoryException);
        }
    }

    private static int getSourceDimensions(OperationMethod operationMethod) {
        Integer n;
        if (operationMethod != null && (n = operationMethod.getSourceDimensions()) != null) {
            return n;
        }
        return 2;
    }

    private OperationMethod parseMethod(Element element, String ... stringArray) throws ParseException {
        Element element2 = element.pullElement(2, stringArray);
        String string = element2.pullString("method");
        Map<String, Object> map = this.parseMetadataAndClose(element2, string, null);
        Identifier identifier = GeodeticObjectParser.toIdentifier(map.remove("identifiers"));
        FactoryException factoryException = null;
        if (identifier instanceof ReferenceIdentifier) {
            try {
                return this.referencing.getOperationMethod(this.opFactory, this.mtFactory, ((ReferenceIdentifier)identifier).getCodeSpace() + ':' + identifier.getCode());
            }
            catch (FactoryException factoryException2) {
                factoryException = factoryException2;
            }
        }
        try {
            return this.referencing.getOperationMethod(this.opFactory, this.mtFactory, string);
        }
        catch (FactoryException factoryException3) {
            if (factoryException != null) {
                // empty if block
            }
            throw element2.parseFailed(factoryException3);
        }
    }

    private Conversion parseDerivingConversion(int n, Element element, String string, Unit<?> unit, Unit<Angle> unit2) throws ParseException {
        String string2;
        if (string == null) {
            string2 = null;
        } else {
            if ((element = element.pullElement(n, string)) == null) {
                return null;
            }
            string2 = element.pullString("name");
        }
        OperationMethod operationMethod = this.parseMethod(element, "Method", "Projection");
        Map<String, Object> map = this.properties;
        ParameterValueGroup parameterValueGroup = operationMethod.getParameters().createValue();
        this.parseParameters(element, parameterValueGroup, unit, unit2);
        if (string != null) {
            map = this.parseMetadataAndClose(element, string2, operationMethod);
        }
        try {
            return this.opFactory.createDefiningConversion(map, operationMethod, parameterValueGroup);
        }
        catch (FactoryException factoryException) {
            throw element.parseFailed(factoryException);
        }
    }

    private GeodeticDatum parseDatum(int n, Element element, PrimeMeridian primeMeridian) throws ParseException {
        Element element2 = element.pullElement(n, "Datum", "GeodeticDatum");
        if (element2 == null) {
            return null;
        }
        String string = element2.pullString("name");
        Ellipsoid ellipsoid = this.parseEllipsoid(2, element2);
        Object object = this.parseToWGS84(1, element2);
        Map<String, Object> map = this.parseAnchorAndClose(element2, string);
        if (primeMeridian == null) {
            primeMeridian = this.referencing.getGreenwich();
        }
        if (object != null) {
            map.put("bursaWolf", object);
        }
        try {
            return this.datumFactory.createGeodeticDatum(map, ellipsoid, primeMeridian);
        }
        catch (FactoryException factoryException) {
            throw element2.parseFailed(factoryException);
        }
    }

    private VerticalDatum parseVerticalDatum(int n, Element element, boolean bl) throws ParseException {
        Element element2 = element.pullElement(n, "VerticalDatum", "VDatum", "Vert_Datum");
        if (element2 == null) {
            return null;
        }
        String string = element2.pullString("name");
        VerticalDatumType verticalDatumType = null;
        if (bl) {
            verticalDatumType = VerticalDatumTypes.fromLegacy(element2.pullInteger("datum"));
        }
        if (verticalDatumType == null) {
            verticalDatumType = VerticalDatumTypes.guess(string, null, null);
        }
        try {
            return this.datumFactory.createVerticalDatum(this.parseAnchorAndClose(element2, string), verticalDatumType);
        }
        catch (FactoryException factoryException) {
            throw element2.parseFailed(factoryException);
        }
    }

    private TemporalDatum parseTimeDatum(int n, Element element) throws ParseException {
        Element element2 = element.pullElement(n, "TimeDatum", "TDatum");
        if (element2 == null) {
            return null;
        }
        String string = element2.pullString("name");
        Element element3 = element2.pullElement(2, "TimeOrigin");
        Date date = element3.pullDate("origin");
        element3.close(this.ignoredElements);
        try {
            return this.datumFactory.createTemporalDatum(this.parseAnchorAndClose(element2, string), date);
        }
        catch (FactoryException factoryException) {
            throw element2.parseFailed(factoryException);
        }
    }

    private EngineeringDatum parseEngineeringDatum(int n, Element element, boolean bl) throws ParseException {
        Element element2 = element.pullElement(n, "EngineeringDatum", "EDatum", "Local_Datum");
        if (element2 == null) {
            return null;
        }
        String string = element2.pullString("name");
        if (bl) {
            element2.pullInteger("datum");
        }
        try {
            return this.datumFactory.createEngineeringDatum(this.parseAnchorAndClose(element2, string));
        }
        catch (FactoryException factoryException) {
            throw element2.parseFailed(factoryException);
        }
    }

    private ImageDatum parseImageDatum(int n, Element element) throws ParseException {
        Element element2 = element.pullElement(n, "ImageDatum", "IDatum");
        if (element2 == null) {
            return null;
        }
        String string = element2.pullString("name");
        PixelInCell pixelInCell = Types.forCodeName(PixelInCell.class, element2.pullVoidElement((String)"pixelInCell").keyword, true);
        try {
            return this.datumFactory.createImageDatum(this.parseAnchorAndClose(element2, string), pixelInCell);
        }
        catch (FactoryException factoryException) {
            throw element2.parseFailed(factoryException);
        }
    }

    private SingleCRS parseEngineeringCRS(int n, Element element, boolean bl) throws ParseException {
        String[] stringArray;
        if (bl) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "BaseEngCRS";
        } else {
            String[] stringArray3 = new String[3];
            stringArray3[0] = "EngineeringCRS";
            stringArray3[1] = "EngCRS";
            stringArray = stringArray3;
            stringArray3[2] = "Local_CS";
        }
        Element element2 = element.pullElement(n, stringArray);
        if (element2 == null) {
            return null;
        }
        boolean bl2 = element2.getKeywordIndex() == 2;
        String string = element2.pullString("name");
        Unit<?> unit = this.parseUnit(element2);
        EngineeringDatum engineeringDatum = null;
        SingleCRS singleCRS = null;
        Conversion conversion = null;
        if (!bl2 && !bl && (conversion = this.parseDerivingConversion(1, element2, "DerivingConversion", unit, null)) != null && (singleCRS = this.parseEngineeringCRS(1, element2, true)) == null && (singleCRS = this.parseGeodeticCRS(1, element2, GeodeticObjectParser.getSourceDimensions(conversion.getMethod()), "ellipsoidal")) == null) {
            singleCRS = this.parseProjectedCRS(2, element2, true);
        }
        if (singleCRS == null) {
            engineeringDatum = this.parseEngineeringDatum(2, element2, bl2);
        }
        try {
            CoordinateSystem coordinateSystem = this.parseCoordinateSystem(element2, null, 1, bl2, unit, engineeringDatum);
            Map<String, Object> map = this.parseMetadataAndClose(element2, string, engineeringDatum);
            if (singleCRS != null) {
                return this.crsFactory.createDerivedCRS(map, singleCRS, conversion, coordinateSystem);
            }
            return this.crsFactory.createEngineeringCRS(map, engineeringDatum, coordinateSystem);
        }
        catch (FactoryException factoryException) {
            throw element2.parseFailed(factoryException);
        }
    }

    private ImageCRS parseImageCRS(int n, Element element) throws ParseException {
        CoordinateSystem coordinateSystem;
        Element element2 = element.pullElement(n, "ImageCRS");
        if (element2 == null) {
            return null;
        }
        String string = element2.pullString("name");
        ImageDatum imageDatum = this.parseImageDatum(2, element2);
        Unit<?> unit = this.parseUnit(element2);
        try {
            coordinateSystem = this.parseCoordinateSystem(element2, "Cartesian", 2, false, unit, imageDatum);
            Map<String, Object> map = this.parseMetadataAndClose(element2, string, imageDatum);
            if (coordinateSystem instanceof CartesianCS) {
                return this.crsFactory.createImageCRS(map, imageDatum, (CartesianCS)coordinateSystem);
            }
        }
        catch (FactoryException factoryException) {
            throw element2.parseFailed(factoryException);
        }
        throw element2.illegalCS(coordinateSystem);
    }

    private SingleCRS parseGeodeticCRS(int n, Element element, int n2, String string) throws ParseException {
        CoordinateSystem coordinateSystem;
        Unit<Angle> unit;
        Unit<Angle> unit2;
        boolean bl;
        String[] stringArray;
        if (string != null) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "BaseGeodCRS";
            stringArray = stringArray2;
            stringArray2[1] = "GeogCS";
        } else {
            String[] stringArray3 = new String[4];
            stringArray3[0] = "GeodeticCRS";
            stringArray3[1] = "GeogCS";
            stringArray3[2] = "GeodCRS";
            stringArray = stringArray3;
            stringArray3[3] = "GeocCS";
        }
        Element element2 = element.pullElement(n, stringArray);
        if (element2 == null) {
            return null;
        }
        switch (element2.getKeywordIndex()) {
            default: {
                bl = false;
                unit2 = this.parseUnit(element2);
                if (Units.isAngular(unit2)) {
                    unit = unit2.asType(Angle.class);
                    break;
                }
                unit = NonSI.DEGREE_ANGLE;
                if (unit2 != null || !"ellipsoidal".equals(string)) break;
                unit2 = NonSI.DEGREE_ANGLE;
                break;
            }
            case 1: {
                bl = true;
                string = "ellipsoidal";
                unit2 = unit = this.parseScaledUnit(element2, "AngleUnit", (Unit)SI.RADIAN);
                n2 = 2;
                break;
            }
            case 3: {
                bl = true;
                string = "Cartesian";
                unit = NonSI.DEGREE_ANGLE;
                unit2 = this.parseScaledUnit(element2, "LengthUnit", (Unit)SI.METRE);
                n2 = 3;
            }
        }
        String string2 = element2.pullString("name");
        SingleCRS singleCRS = null;
        Conversion conversion = null;
        if (!bl && string == null && (conversion = this.parseDerivingConversion(1, element2, "DerivingConversion", unit2, unit)) != null) {
            singleCRS = this.parseGeodeticCRS(2, element2, GeodeticObjectParser.getSourceDimensions(conversion.getMethod()), "ellipsoidal");
        }
        try {
            coordinateSystem = this.parseCoordinateSystem(element2, string, n2, bl, unit2, null);
            if (singleCRS != null) {
                Map<String, Object> map = this.parseMetadataAndClose(element2, string2, null);
                return this.crsFactory.createDerivedCRS(map, singleCRS, conversion, coordinateSystem);
            }
            unit = AxisDirections.getAngularUnit(coordinateSystem, unit);
            PrimeMeridian primeMeridian = this.parsePrimeMeridian(1, element2, bl, unit);
            GeodeticDatum geodeticDatum = this.parseDatum(2, element2, primeMeridian);
            Map<String, Object> map = this.parseMetadataAndClose(element2, string2, geodeticDatum);
            if (coordinateSystem instanceof EllipsoidalCS) {
                return this.crsFactory.createGeographicCRS(map, geodeticDatum, (EllipsoidalCS)coordinateSystem);
            }
            if (coordinateSystem instanceof CartesianCS) {
                return this.crsFactory.createGeocentricCRS(map, geodeticDatum, this.referencing.upgradeGeocentricCS((CartesianCS)coordinateSystem));
            }
            if (coordinateSystem instanceof SphericalCS) {
                return this.crsFactory.createGeocentricCRS(map, geodeticDatum, (SphericalCS)coordinateSystem);
            }
        }
        catch (FactoryException factoryException) {
            throw element2.parseFailed(factoryException);
        }
        throw element2.illegalCS(coordinateSystem);
    }

    private SingleCRS parseVerticalCRS(int n, Element element, boolean bl) throws ParseException {
        CoordinateSystem coordinateSystem;
        String[] stringArray;
        if (bl) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "BaseVertCRS";
        } else {
            String[] stringArray3 = new String[3];
            stringArray3[0] = "VerticalCRS";
            stringArray3[1] = "VertCRS";
            stringArray = stringArray3;
            stringArray3[2] = "Vert_CS";
        }
        Element element2 = element.pullElement(n, stringArray);
        if (element2 == null) {
            return null;
        }
        boolean bl2 = element2.getKeywordIndex() == 2;
        String string = element2.pullString("name");
        Unit<?> unit = this.parseUnit(element2);
        VerticalDatum verticalDatum = null;
        SingleCRS singleCRS = null;
        Conversion conversion = null;
        if (!bl2 && !bl && (conversion = this.parseDerivingConversion(1, element2, "DerivingConversion", unit, null)) != null) {
            singleCRS = this.parseVerticalCRS(2, element2, true);
        }
        if (singleCRS == null) {
            verticalDatum = this.parseVerticalDatum(2, element2, bl2);
        }
        try {
            coordinateSystem = this.parseCoordinateSystem(element2, "vertical", 1, bl2, unit, verticalDatum);
            Map<String, Object> map = this.parseMetadataAndClose(element2, string, verticalDatum);
            if (coordinateSystem instanceof VerticalCS) {
                VerticalDatumType verticalDatumType;
                if (singleCRS != null) {
                    return this.crsFactory.createDerivedCRS(map, singleCRS, conversion, coordinateSystem);
                }
                if (VerticalDatumType.OTHER_SURFACE.equals(verticalDatum.getVerticalDatumType()) && !VerticalDatumType.OTHER_SURFACE.equals(verticalDatumType = VerticalDatumTypes.guess(verticalDatum.getName().getCode(), verticalDatum.getAlias(), coordinateSystem.getAxis(0)))) {
                    verticalDatum = this.datumFactory.createVerticalDatum(this.referencing.getProperties(verticalDatum), verticalDatumType);
                }
                this.verticalCRS = this.crsFactory.createVerticalCRS(map, verticalDatum, (VerticalCS)coordinateSystem);
                if (this.verticalElements != null) {
                    this.verticalElements = this.verticalElements.resolve(this.verticalCRS);
                }
                return this.verticalCRS;
            }
        }
        catch (FactoryException factoryException) {
            throw element2.parseFailed(factoryException);
        }
        throw element2.illegalCS(coordinateSystem);
    }

    private SingleCRS parseTimeCRS(int n, Element element, boolean bl) throws ParseException {
        CoordinateSystem coordinateSystem;
        Element element2 = element.pullElement(n, bl ? "BaseTimeCRS" : "TimeCRS");
        if (element2 == null) {
            return null;
        }
        String string = element2.pullString("name");
        Unit unit = this.parseScaledUnit(element2, "TimeUnit", (Unit)SI.SECOND);
        TemporalDatum temporalDatum = null;
        SingleCRS singleCRS = null;
        Conversion conversion = null;
        if (!bl && (conversion = this.parseDerivingConversion(1, element2, "DerivingConversion", unit, null)) != null) {
            singleCRS = this.parseTimeCRS(2, element2, true);
        }
        if (singleCRS == null) {
            temporalDatum = this.parseTimeDatum(2, element2);
        }
        try {
            coordinateSystem = this.parseCoordinateSystem(element2, "temporal", 1, false, unit, temporalDatum);
            Map<String, Object> map = this.parseMetadataAndClose(element2, string, temporalDatum);
            if (coordinateSystem instanceof TimeCS) {
                if (singleCRS != null) {
                    return this.crsFactory.createDerivedCRS(map, singleCRS, conversion, coordinateSystem);
                }
                return this.crsFactory.createTemporalCRS(map, temporalDatum, (TimeCS)coordinateSystem);
            }
        }
        catch (FactoryException factoryException) {
            throw element2.parseFailed(factoryException);
        }
        throw element2.illegalCS(coordinateSystem);
    }

    private ProjectedCRS parseProjectedCRS(int n, Element element, boolean bl) throws ParseException {
        CoordinateSystem coordinateSystem;
        Unit<Angle> unit;
        BaseUnit baseUnit;
        String[] stringArray;
        if (bl) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "BaseProjCRS";
        } else {
            String[] stringArray3 = new String[3];
            stringArray3[0] = "ProjectedCRS";
            stringArray3[1] = "ProjCRS";
            stringArray = stringArray3;
            stringArray3[2] = "ProjCS";
        }
        Element element2 = element.pullElement(n, stringArray);
        if (element2 == null) {
            return null;
        }
        boolean bl2 = element2.getKeywordIndex() == 2;
        String string = element2.pullString("name");
        SingleCRS singleCRS = this.parseGeodeticCRS(2, element2, 2, "ellipsoidal");
        if (!(singleCRS instanceof GeographicCRS)) {
            throw new LocalizedParseException(this.errorLocale, 194, new Object[]{singleCRS.getClass()}, element2.offset);
        }
        BaseUnit baseUnit2 = this.parseScaledUnit(element2, "LengthUnit", (Unit)SI.METRE);
        if (bl2 && this.usesCommonUnits) {
            baseUnit = SI.METRE;
            unit = NonSI.DEGREE_ANGLE;
        } else {
            baseUnit = baseUnit2;
            unit = AxisDirections.getAngularUnit(singleCRS.getCoordinateSystem(), (Unit<Angle>)NonSI.DEGREE_ANGLE);
        }
        Conversion conversion = this.parseDerivingConversion(2, element2, bl2 ? null : "Conversion", (Unit<?>)baseUnit, unit);
        if (baseUnit2 == null && bl) {
            baseUnit2 = SI.METRE;
        }
        try {
            coordinateSystem = this.parseCoordinateSystem(element2, "Cartesian", 2, bl2, (Unit<?>)baseUnit2, singleCRS.getDatum());
            Map<String, Object> map = this.parseMetadataAndClose(element2, string, conversion);
            if (coordinateSystem instanceof CartesianCS) {
                return this.crsFactory.createProjectedCRS(map, (GeographicCRS)singleCRS, conversion, (CartesianCS)coordinateSystem);
            }
        }
        catch (FactoryException factoryException) {
            throw element2.parseFailed(factoryException);
        }
        throw element2.illegalCS(coordinateSystem);
    }

    private CompoundCRS parseCompoundCRS(int n, Element element) throws ParseException {
        CoordinateReferenceSystem coordinateReferenceSystem;
        Element element2 = element.pullElement(n, "CompoundCRS", "Compd_CS");
        if (element2 == null) {
            return null;
        }
        String string = element2.pullString("name");
        ArrayList<CoordinateReferenceSystem> arrayList = new ArrayList<CoordinateReferenceSystem>(4);
        while ((coordinateReferenceSystem = this.parseCoordinateReferenceSystem(element2, arrayList.size() < 2)) != null) {
            arrayList.add(coordinateReferenceSystem);
        }
        try {
            return this.crsFactory.createCompoundCRS(this.parseMetadataAndClose(element2, string, null), arrayList.toArray(new CoordinateReferenceSystem[arrayList.size()]));
        }
        catch (FactoryException factoryException) {
            throw element2.parseFailed(factoryException);
        }
    }

    private DerivedCRS parseFittedCS(int n, Element element) throws ParseException {
        Element element2 = element.pullElement(n, "Fitted_CS");
        if (element2 == null) {
            return null;
        }
        String string = element2.pullString("name");
        MathTransform mathTransform = this.parseMathTransform(element2, true);
        OperationMethod operationMethod = this.getOperationMethod();
        CoordinateReferenceSystem coordinateReferenceSystem = this.parseCoordinateReferenceSystem(element2, true);
        if (!(coordinateReferenceSystem instanceof SingleCRS)) {
            throw new LocalizedParseException(this.errorLocale, 191, new Object[]{"Fitted_CS", coordinateReferenceSystem.getClass()}, element2.offset);
        }
        CoordinateSystemAxis[] coordinateSystemAxisArray = new CoordinateSystemAxis[mathTransform.getSourceDimensions()];
        StringBuilder stringBuilder = new StringBuilder(string).append(" axis ");
        int n2 = stringBuilder.length();
        try {
            Object object;
            for (int i = 0; i < coordinateSystemAxisArray.length; ++i) {
                object = String.valueOf(i);
                stringBuilder.setLength(n2);
                stringBuilder.append((String)object);
                coordinateSystemAxisArray[i] = this.csFactory.createCoordinateSystemAxis(Collections.singletonMap("name", stringBuilder.toString()), (String)object, AxisDirection.OTHER, Unit.ONE);
            }
            Map<String, Object> map = this.parseMetadataAndClose(element2, string, coordinateReferenceSystem);
            object = this.referencing.createAbstractCS(Collections.singletonMap("name", AxisDirections.appendTo(new StringBuilder("CS"), coordinateSystemAxisArray)), coordinateSystemAxisArray);
            map.put("conversion.name", string);
            return this.referencing.createDerivedCRS(map, (SingleCRS)coordinateReferenceSystem, operationMethod, mathTransform.inverse(), (CoordinateSystem)object);
        }
        catch (FactoryException factoryException) {
            throw element2.parseFailed(factoryException);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            throw element2.parseFailed(noninvertibleTransformException);
        }
    }

    private CoordinateOperation parseOperation(int n, Element element) throws ParseException {
        Element element2 = element.pullElement(n, "CoordinateOperation");
        if (element2 == null) {
            return null;
        }
        String string = element2.pullString("name");
        CoordinateReferenceSystem coordinateReferenceSystem = this.parseCoordinateReferenceSystem(element2, 2, "SourceCRS");
        CoordinateReferenceSystem coordinateReferenceSystem2 = this.parseCoordinateReferenceSystem(element2, 2, "TargetCRS");
        CoordinateReferenceSystem coordinateReferenceSystem3 = this.parseCoordinateReferenceSystem(element2, 1, "InterpolationCRS");
        OperationMethod operationMethod = this.parseMethod(element2, "Method");
        Element element3 = element2.pullElement(1, "OperationAccuracy");
        Map<String, Object> map = this.parseMetadataAndClose(element2, string, operationMethod);
        ParameterValueGroup parameterValueGroup = operationMethod.getParameters().createValue();
        this.parseParameters(element2, parameterValueGroup, null, null);
        map.put("parameters", parameterValueGroup);
        if (element3 != null) {
            element3.pullDouble("accuracy");
            element3.close(this.ignoredElements);
        }
        try {
            return this.referencing.createSingleOperation(map, coordinateReferenceSystem, coordinateReferenceSystem2, coordinateReferenceSystem3, operationMethod, this.opFactory);
        }
        catch (FactoryException factoryException) {
            throw element2.parseFailed(factoryException);
        }
    }
}

