/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.content;

import java.util.Collection;
import java.util.Locale;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.metadata.LegacyPropertyAdapter;
import org.apache.sis.metadata.iso.content.AbstractContentInformation;
import org.apache.sis.metadata.iso.content.DefaultFeatureTypeInfo;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.content.FeatureCatalogueDescription;
import org.opengis.util.GenericName;

@XmlType(name="MD_FeatureCatalogueDescription_Type", propOrder={"compliant", "languages", "includedWithDataset", "featureTypes", "featureCatalogueCitations"})
@XmlRootElement(name="MD_FeatureCatalogueDescription")
public class DefaultFeatureCatalogueDescription
extends AbstractContentInformation
implements FeatureCatalogueDescription {
    private static final long serialVersionUID = 5731044701122380718L;
    private Boolean compliant;
    private Collection<Locale> languages;
    private boolean includedWithDataset;
    private Collection<DefaultFeatureTypeInfo> featureTypes;
    private Collection<Citation> featureCatalogueCitations;

    public DefaultFeatureCatalogueDescription() {
    }

    public DefaultFeatureCatalogueDescription(FeatureCatalogueDescription featureCatalogueDescription) {
        super(featureCatalogueDescription);
        if (featureCatalogueDescription != null) {
            this.compliant = featureCatalogueDescription.isCompliant();
            this.includedWithDataset = featureCatalogueDescription.isIncludedWithDataset();
            this.languages = this.copyCollection(featureCatalogueDescription.getLanguages(), Locale.class);
            this.featureCatalogueCitations = this.copyCollection(featureCatalogueDescription.getFeatureCatalogueCitations(), Citation.class);
            if (featureCatalogueDescription instanceof DefaultFeatureCatalogueDescription) {
                this.featureTypes = this.copyCollection(((DefaultFeatureCatalogueDescription)featureCatalogueDescription).getFeatureTypeInfo(), DefaultFeatureTypeInfo.class);
            } else {
                this.setFeatureTypes(featureCatalogueDescription.getFeatureTypes());
            }
        }
    }

    public static DefaultFeatureCatalogueDescription castOrCopy(FeatureCatalogueDescription featureCatalogueDescription) {
        if (featureCatalogueDescription == null || featureCatalogueDescription instanceof DefaultFeatureCatalogueDescription) {
            return (DefaultFeatureCatalogueDescription)featureCatalogueDescription;
        }
        return new DefaultFeatureCatalogueDescription(featureCatalogueDescription);
    }

    @Override
    @XmlElement(name="complianceCode")
    public Boolean isCompliant() {
        return this.compliant;
    }

    public void setCompliant(Boolean bl) {
        this.checkWritePermission();
        this.compliant = bl;
    }

    @Override
    @XmlElement(name="language")
    public Collection<Locale> getLanguages() {
        this.languages = this.nonNullCollection(this.languages, Locale.class);
        return this.languages;
    }

    public void setLanguages(Collection<? extends Locale> collection) {
        this.languages = this.writeCollection(collection, this.languages, Locale.class);
    }

    @Override
    @XmlElement(name="includedWithDataset", required=true)
    public boolean isIncludedWithDataset() {
        return this.includedWithDataset;
    }

    public void setIncludedWithDataset(boolean bl) {
        this.checkWritePermission();
        this.includedWithDataset = bl;
    }

    @UML(identifier="featureTypes", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<DefaultFeatureTypeInfo> getFeatureTypeInfo() {
        this.featureTypes = this.nonNullCollection(this.featureTypes, DefaultFeatureTypeInfo.class);
        return this.featureTypes;
    }

    public void setFeatureTypeInfo(Collection<? extends DefaultFeatureTypeInfo> collection) {
        this.featureTypes = this.writeCollection(collection, this.featureTypes, DefaultFeatureTypeInfo.class);
    }

    @Deprecated
    @XmlElement(name="featureTypes")
    public final Collection<GenericName> getFeatureTypes() {
        return new LegacyPropertyAdapter<GenericName, DefaultFeatureTypeInfo>(this.getFeatureTypeInfo()){

            @Override
            protected DefaultFeatureTypeInfo wrap(GenericName genericName) {
                return new DefaultFeatureTypeInfo(genericName);
            }

            @Override
            protected GenericName unwrap(DefaultFeatureTypeInfo defaultFeatureTypeInfo) {
                return defaultFeatureTypeInfo.getFeatureTypeName();
            }

            @Override
            protected boolean update(DefaultFeatureTypeInfo defaultFeatureTypeInfo, GenericName genericName) {
                if (defaultFeatureTypeInfo instanceof DefaultFeatureTypeInfo) {
                    defaultFeatureTypeInfo.setFeatureTypeName(genericName);
                    return true;
                }
                return false;
            }
        }.validOrNull();
    }

    @Deprecated
    public void setFeatureTypes(Collection<? extends GenericName> collection) {
        this.checkWritePermission();
        ((LegacyPropertyAdapter)this.getFeatureTypes()).setValues(collection);
    }

    @XmlElement(name="featureCatalogueCitation", required=true)
    public Collection<Citation> getFeatureCatalogueCitations() {
        this.featureCatalogueCitations = this.nonNullCollection(this.featureCatalogueCitations, Citation.class);
        return this.featureCatalogueCitations;
    }

    public void setFeatureCatalogueCitations(Collection<? extends Citation> collection) {
        this.featureCatalogueCitations = this.writeCollection(collection, this.featureCatalogueCitations, Citation.class);
    }
}

