/*
 * Decompiled with CFR 0.152.
 */
package org.structr.agent;

import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import org.structr.agent.Task;
import org.structr.core.entity.Principal;
import org.structr.core.graph.NodeInterface;

public class AbstractTask<T extends NodeInterface>
implements Task<T> {
    private final Map<String, Object> statusProperties = new LinkedHashMap<String, Object>();
    private final List<T> nodes = new LinkedList<T>();
    private Principal user = null;
    private int priority = 0;
    private Date scheduledTime = null;
    private Date creationTime = null;
    private String type = null;
    private long delay = 0L;

    public AbstractTask(String type, Principal user, T node) {
        this.type = type;
        this.user = user;
        this.nodes.add(node);
    }

    @Override
    public Principal getUser() {
        return this.user;
    }

    @Override
    public List<T> getNodes() {
        return this.nodes;
    }

    @Override
    public int priority() {
        return this.priority;
    }

    @Override
    public Date getScheduledTime() {
        return this.scheduledTime;
    }

    @Override
    public Date getCreationTime() {
        return this.creationTime;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public long getDelay(TimeUnit unit) {
        if (unit != null) {
            return unit.convert(this.delay, TimeUnit.MILLISECONDS);
        }
        return this.delay;
    }

    @Override
    public Object getStatusProperty(String key) {
        return this.statusProperties.get(key);
    }

    public void setStatusProperty(String key, Object value) {
        this.statusProperties.put(key, value);
    }

    public void addNode(T node) {
        this.nodes.add(node);
    }

    public void setUser(Principal user) {
        this.user = user;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public void setScheduledTime(Date scheduledTime) {
        this.scheduledTime = scheduledTime;
    }

    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    @Override
    public int compareTo(Delayed other) {
        long otherDelay = other.getDelay(TimeUnit.MILLISECONDS);
        return this.delay > otherDelay ? 1 : (this.delay < otherDelay ? -1 : 0);
    }
}

