/*
 * Decompiled with CFR 0.152.
 */
package org.structr.agent;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.agent.Agent;
import org.structr.agent.ProcessTaskCommand;
import org.structr.agent.StatusInfo;
import org.structr.agent.Task;
import org.structr.api.service.Command;
import org.structr.api.service.RunnableService;
import org.structr.api.service.StructrServices;
import org.structr.core.Services;
import org.structr.schema.ConfigurationProvider;

public class AgentService
extends Thread
implements RunnableService {
    private static final Logger logger = LoggerFactory.getLogger((String)AgentService.class.getName());
    private final int maxAgents = 4;
    private final Map<String, List<Agent>> runningAgents = new ConcurrentHashMap<String, List<Agent>>(10, 0.9f, 8);
    private final Map<String, Class> agentClassCache = new ConcurrentHashMap<String, Class>(10, 0.9f, 8);
    private final Queue<Task> taskQueue = new ConcurrentLinkedQueue<Task>();
    private Set<Class> supportedCommands = new LinkedHashSet<Class>();
    private boolean run = false;

    public AgentService() {
        super("AgentService");
        this.supportedCommands.add(ProcessTaskCommand.class);
        super.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processTask(Task task) {
        Queue<Task> queue = this.taskQueue;
        synchronized (queue) {
            this.taskQueue.add(task);
            logger.debug("Task {} added to task queue", (Object)task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Agent findAgentForTask(Task task) {
        List<Agent> agents;
        List<Agent> list = agents = this.getRunningAgentsForTask(task.getClass());
        synchronized (list) {
            for (Agent agent : agents) {
                if (!agent.getTaskQueue().contains(task)) continue;
                return agent;
            }
        }
        return null;
    }

    @Override
    public void run() {
        logger.info("AgentService started");
        while (this.run) {
            Task nextTask = this.taskQueue.poll();
            if (nextTask != null) {
                this.assignNextAgentForTask(nextTask);
            }
            try {
                Thread.sleep(10L);
            }
            catch (Throwable throwable) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyAgentStart(Agent agent) {
        List<Agent> agents;
        List<Agent> list = agents = this.getRunningAgentsForTask(agent.getSupportedTaskType());
        synchronized (list) {
            agents.add(agent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyAgentStop(Agent agent) {
        List<Agent> agents;
        List<Agent> list = agents = this.getRunningAgentsForTask(agent.getSupportedTaskType());
        synchronized (list) {
            agents.remove(agent);
        }
    }

    public Map<String, Class<? extends Agent>> getAgents() {
        ConfigurationProvider configuration = Services.getInstance().getConfigurationProvider();
        if (configuration != null) {
            return configuration.getAgents();
        }
        return Collections.emptyMap();
    }

    public void injectArguments(Command command) {
        command.setArgument("agentService", (Object)this);
    }

    public void initialize(StructrServices services) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
    }

    public void initialized() {
    }

    public void shutdown() {
    }

    public void startService() throws Exception {
        this.run = true;
        this.start();
    }

    public void stopService() {
        this.run = false;
    }

    public boolean runOnStartup() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assignNextAgentForTask(Task nextTask) {
        List<Agent> agents;
        Class<?> taskClass = nextTask.getClass();
        Collection<StatusInfo> collection = agents = this.getRunningAgentsForTask(taskClass);
        synchronized (collection) {
            for (Agent agent : agents) {
                if (!agent.assignTask(nextTask)) continue;
                logger.debug("Task assigned to agent {}", (Object)agent.getName());
                return;
            }
        }
        if (agents.size() < 4) {
            Agent agent = this.createAgent(nextTask);
            if (agent != null && agent.assignTask(nextTask)) {
                agent.start();
            } else {
                Queue<Task> queue = this.taskQueue;
                synchronized (queue) {
                    this.taskQueue.add(nextTask);
                }
            }
        } else {
            logger.debug("Overall agents limit reached, re-queueing task");
            collection = this.taskQueue;
            synchronized (collection) {
                this.taskQueue.add(nextTask);
            }
        }
    }

    private Agent createAgent(Task forTask) {
        Agent agent = null;
        try {
            agent = this.lookupAgent(forTask);
            if (agent != null) {
                agent.setAgentService(this);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return agent;
    }

    private Agent lookupAgent(Task task) {
        Map<String, Class<? extends Agent>> agentClassesMap;
        Class<?> taskClass = task.getClass();
        Agent agent = null;
        Class<? extends Agent> agentClass = this.agentClassCache.get(taskClass.getName());
        if (agentClass == null && (agentClassesMap = this.getAgents()) != null) {
            for (Map.Entry<String, Class<? extends Agent>> classEntry : agentClassesMap.entrySet()) {
                Class<? extends Agent> supportedAgentClass = agentClassesMap.get(classEntry.getKey());
                try {
                    Agent supportedAgent = supportedAgentClass.newInstance();
                    Class supportedTaskClass = supportedAgent.getSupportedTaskType();
                    if (supportedTaskClass.equals(taskClass)) {
                        agentClass = supportedAgentClass;
                    }
                    this.agentClassCache.put(supportedTaskClass.getName(), supportedAgentClass);
                }
                catch (Throwable throwable) {}
            }
        }
        if (agentClass != null) {
            try {
                agent = (Agent)agentClass.newInstance();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return agent;
    }

    public Collection<Task> getTaskQueue() {
        return this.taskQueue;
    }

    public Map<String, List<Agent>> getRunningAgents() {
        return this.runningAgents;
    }

    private List<Agent> getRunningAgentsForTask(Class taskClass) {
        List<Agent<Object>> agents = this.runningAgents.get(taskClass.getName());
        if (agents == null) {
            agents = Collections.synchronizedList(new LinkedList());
            this.runningAgents.put(taskClass.getName(), agents);
        }
        return agents;
    }

    public boolean isRunning() {
        return this.run;
    }

    public boolean isVital() {
        return false;
    }

    public String getModuleName() {
        return "agents";
    }
}

