/*
 * Decompiled with CFR 0.152.
 */
package org.structr.cmis.wrapper;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.commons.data.Ace;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.AllowableActions;
import org.apache.chemistry.opencmis.commons.data.ChangeEventInfo;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.PolicyIdList;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.data.RenditionData;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.PropertyType;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.BindingsObjectFactoryImpl;
import org.apache.chemistry.opencmis.commons.spi.BindingsObjectFactory;
import org.structr.api.config.Settings;
import org.structr.cmis.CMISInfo;
import org.structr.cmis.common.CMISExtensionsData;
import org.structr.cmis.info.CMISObjectInfo;
import org.structr.cmis.wrapper.CMISDocumentWrapper;
import org.structr.cmis.wrapper.CMISFolderWrapper;
import org.structr.cmis.wrapper.CMISItemWrapper;
import org.structr.cmis.wrapper.CMISPolicyWrapper;
import org.structr.cmis.wrapper.CMISRelationshipWrapper;
import org.structr.cmis.wrapper.CMISSecondaryWrapper;
import org.structr.cmis.wrapper.FilteredPropertyList;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.Principal;
import org.structr.core.entity.SuperUser;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.PropertyMap;

public abstract class CMISObjectWrapper<T extends CMISObjectInfo>
extends CMISExtensionsData
implements ObjectData,
Acl {
    protected AllowableActions allowableActions = null;
    protected List<Ace> aces = null;
    protected PropertyMap dynamicPropertyMap = null;
    protected GregorianCalendar lastModificationDate = null;
    protected GregorianCalendar creationDate = null;
    protected BaseTypeId baseTypeId = null;
    protected String lastModifiedBy = null;
    protected String propertyFilter = null;
    protected String description = null;
    protected String createdBy = null;
    protected String type = null;
    protected String name = null;
    protected String id = null;
    protected boolean includeActions = false;

    public abstract void createProperties(BindingsObjectFactory var1, FilteredPropertyList var2);

    public CMISObjectWrapper(BaseTypeId baseTypeId, String propertyFilter, Boolean includeActions) {
        this.includeActions = includeActions != null && includeActions != false;
        this.propertyFilter = propertyFilter;
        this.baseTypeId = baseTypeId;
    }

    public String getId() {
        return this.id;
    }

    public BaseTypeId getBaseTypeId() {
        return this.baseTypeId;
    }

    public GregorianCalendar getLastModifiedDate() {
        return this.lastModificationDate;
    }

    public void setLastModificationDate(GregorianCalendar lastModifiedDate) {
        this.lastModificationDate = lastModifiedDate;
    }

    public GregorianCalendar getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(GregorianCalendar creationDate) {
        this.creationDate = creationDate;
    }

    public String getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    public void setLastModifiedBy(String lastModifiedBy) throws FrameworkException {
        this.lastModifiedBy = CMISObjectWrapper.translateIdToUsername(lastModifiedBy);
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) throws FrameworkException {
        this.createdBy = CMISObjectWrapper.translateIdToUsername(createdBy);
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setBaseTypeId(BaseTypeId baseTypeId) {
        this.baseTypeId = baseTypeId;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Properties getProperties() {
        FilteredPropertyList properties = new FilteredPropertyList(this.propertyFilter);
        BindingsObjectFactoryImpl objFactory = new BindingsObjectFactoryImpl();
        properties.add((PropertyData<?>)objFactory.createPropertyIdData("cmis:baseTypeId", this.baseTypeId.value()));
        properties.add((PropertyData<?>)objFactory.createPropertyIdData("cmis:objectTypeId", this.type));
        properties.add((PropertyData<?>)objFactory.createPropertyIdData("cmis:objectId", this.id));
        properties.add((PropertyData<?>)objFactory.createPropertyStringData("cmis:name", this.name));
        properties.add((PropertyData<?>)objFactory.createPropertyStringData("cmis:description", this.description));
        properties.add((PropertyData<?>)objFactory.createPropertyStringData("cmis:createdBy", this.createdBy));
        properties.add((PropertyData<?>)objFactory.createPropertyStringData("cmis:lastModifiedBy", this.lastModifiedBy));
        properties.add((PropertyData<?>)objFactory.createPropertyDateTimeData("cmis:creationDate", this.creationDate));
        properties.add((PropertyData<?>)objFactory.createPropertyDateTimeData("cmis:lastModificationDate", this.lastModificationDate));
        if (this.dynamicPropertyMap != null) {
            for (Map.Entry<PropertyKey, Object> entry : this.dynamicPropertyMap.entrySet()) {
                PropertyKey key = entry.getKey();
                PropertyType dataType = key.getDataType();
                if (dataType == null) continue;
                switch (dataType) {
                    case BOOLEAN: {
                        properties.add((PropertyData<?>)objFactory.createPropertyBooleanData(key.jsonName(), (Boolean)entry.getValue()));
                        break;
                    }
                    case DATETIME: {
                        properties.add((PropertyData<?>)objFactory.createPropertyDateTimeData(key.jsonName(), this.valueOrNull((Date)entry.getValue())));
                        break;
                    }
                    case DECIMAL: {
                        properties.add((PropertyData<?>)objFactory.createPropertyDecimalData(key.jsonName(), this.valueOrNull((Double)entry.getValue())));
                        break;
                    }
                    case INTEGER: {
                        properties.add((PropertyData<?>)objFactory.createPropertyIntegerData(key.jsonName(), this.intOrNull(entry.getValue())));
                        break;
                    }
                    case STRING: {
                        properties.add((PropertyData<?>)objFactory.createPropertyStringData(key.jsonName(), (String)entry.getValue()));
                    }
                }
            }
        }
        this.createProperties((BindingsObjectFactory)objFactory, properties);
        return objFactory.createPropertiesData(properties.getList());
    }

    public AllowableActions getAllowableActions() {
        if (this.includeActions) {
            return this.allowableActions;
        }
        return null;
    }

    public List<ObjectData> getRelationships() {
        return null;
    }

    public ChangeEventInfo getChangeEventInfo() {
        return null;
    }

    public Acl getAcl() {
        return this;
    }

    public Boolean isExactAcl() {
        return false;
    }

    public PolicyIdList getPolicyIds() {
        return null;
    }

    public List<RenditionData> getRenditions() {
        return null;
    }

    public void initializeFrom(T info) throws FrameworkException {
        this.setName(info.getName());
        this.setId(info.getUuid());
        this.setType(info.getType());
        this.setCreatedBy(info.getCreatedBy());
        this.setLastModifiedBy(info.getLastModifiedBy());
        this.setCreationDate(info.getCreationDate());
        this.setLastModificationDate(info.getLastModificationDate());
        this.dynamicPropertyMap = info.getDynamicProperties();
        this.allowableActions = info.getAllowableActions();
        this.aces = info.getAccessControlEntries();
    }

    public static CMISObjectWrapper wrap(GraphObject source, String propertyFilter, Boolean includeAllowableActions) throws FrameworkException {
        BaseTypeId baseTypeId;
        CMISInfo cmisInfo;
        CMISObjectWrapper wrapper = null;
        if (source != null && (cmisInfo = source.getCMISInfo()) != null && (baseTypeId = cmisInfo.getBaseTypeId()) != null) {
            switch (baseTypeId) {
                case CMIS_DOCUMENT: {
                    wrapper = new CMISDocumentWrapper(propertyFilter, includeAllowableActions);
                    wrapper.initializeFrom(cmisInfo.getDocumentInfo());
                    break;
                }
                case CMIS_FOLDER: {
                    wrapper = new CMISFolderWrapper(propertyFilter, includeAllowableActions);
                    wrapper.initializeFrom(cmisInfo.getFolderInfo());
                    break;
                }
                case CMIS_ITEM: {
                    wrapper = new CMISItemWrapper(propertyFilter, includeAllowableActions);
                    wrapper.initializeFrom(cmisInfo.geItemInfo());
                    break;
                }
                case CMIS_POLICY: {
                    wrapper = new CMISPolicyWrapper(propertyFilter, includeAllowableActions);
                    wrapper.initializeFrom(cmisInfo.getPolicyInfo());
                    break;
                }
                case CMIS_RELATIONSHIP: {
                    wrapper = new CMISRelationshipWrapper(propertyFilter, includeAllowableActions);
                    wrapper.initializeFrom(cmisInfo.getRelationshipInfo());
                    break;
                }
                case CMIS_SECONDARY: {
                    wrapper = new CMISSecondaryWrapper(propertyFilter, includeAllowableActions);
                    wrapper.initializeFrom(cmisInfo.getSecondaryInfo());
                }
            }
        }
        return wrapper;
    }

    public List<Ace> getAces() {
        return this.aces;
    }

    public Boolean isExact() {
        return true;
    }

    public static String translateIdToUsername(String id) throws FrameworkException {
        if ("00000000000000000000000000000000".equals(id)) {
            return (String)Settings.SuperUserName.getValue();
        }
        Principal principal = StructrApp.getInstance().get(Principal.class, id);
        if (principal != null) {
            return principal.getName();
        }
        return "anonymous";
    }

    public static Principal translateUsernameToPrincipal(String username) throws FrameworkException {
        if (((String)Settings.SuperUserName.getValue()).equals(username)) {
            return new SuperUser();
        }
        Principal principal = StructrApp.getInstance().nodeQuery(Principal.class).andName(username).getFirst();
        if (principal != null) {
            return principal;
        }
        return null;
    }

    protected BigDecimal valueOrNull(Double source) {
        if (source != null) {
            return BigDecimal.valueOf(source);
        }
        return null;
    }

    protected BigInteger intOrNull(Object source) {
        if (source != null && source instanceof Number) {
            Number number = (Number)source;
            return BigInteger.valueOf(number.longValue());
        }
        return null;
    }

    protected GregorianCalendar valueOrNull(Date source) {
        if (source != null) {
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(source);
            return cal;
        }
        return null;
    }
}

