/*
 * Decompiled with CFR 0.152.
 */
package org.structr.common;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.structr.api.graph.Node;
import org.structr.api.graph.PropertyContainer;
import org.structr.api.graph.Relationship;
import org.structr.common.PermissionResolutionMask;
import org.structr.core.graph.NodeInterface;

public class AccessPathCache {
    private static final Map<String, CacheEntry> cache = new ConcurrentHashMap<String, CacheEntry>();
    private static final Set<String> allRelTypes = new HashSet<String>();
    private static final Set<String> allUuids = new HashSet<String>();

    public static PermissionResolutionMask get(NodeInterface startNode, NodeInterface endNode) {
        String cacheKey = AccessPathCache.cacheKey(startNode, endNode);
        CacheEntry entry = cache.get(cacheKey);
        if (entry != null) {
            return entry.mask;
        }
        return null;
    }

    public static void put(NodeInterface startNode, NodeInterface endNode, PermissionResolutionMask mask) {
        CacheEntry entry = AccessPathCache.getOrCreateCacheEntry(startNode, endNode);
        allUuids.add(startNode.getUuid());
        allUuids.add(endNode.getUuid());
        entry.mask = mask;
    }

    public static void update(NodeInterface startNode, NodeInterface endNode, Node node) {
        CacheEntry entry = AccessPathCache.getOrCreateCacheEntry(startNode, endNode);
        String uuid = AccessPathCache.getUuid((PropertyContainer)node);
        if (uuid != null) {
            entry.uuids.add(uuid);
            allUuids.add(uuid);
        }
    }

    public static void update(NodeInterface startNode, NodeInterface endNode, Relationship rel) {
        CacheEntry entry = AccessPathCache.getOrCreateCacheEntry(startNode, endNode);
        String uuid = AccessPathCache.getUuid((PropertyContainer)rel);
        if (uuid != null) {
            String relType = rel.getType().name();
            entry.uuids.add(uuid);
            allUuids.add(uuid);
            entry.relTypes.add(relType);
            allRelTypes.add(relType);
        }
    }

    public static void invalidateForId(String uuid) {
        if (allUuids.contains(uuid)) {
            for (CacheEntry entry : cache.values()) {
                if (!entry.uuids.contains(uuid)) continue;
                cache.remove(entry.key);
            }
            allUuids.remove(uuid);
        }
    }

    public static void invalidateForRelType(String relType) {
        if (allRelTypes.contains(relType)) {
            for (CacheEntry entry : cache.values()) {
                if (!entry.relTypes.contains(relType)) continue;
                cache.remove(entry.key);
            }
            allRelTypes.remove(relType);
        }
    }

    public static void invalidate() {
        allRelTypes.clear();
        allUuids.clear();
        cache.clear();
    }

    private static CacheEntry getOrCreateCacheEntry(NodeInterface startNode, NodeInterface endNode) {
        String cacheKey = AccessPathCache.cacheKey(startNode, endNode);
        CacheEntry entry = cache.get(cacheKey);
        if (entry == null) {
            entry = new CacheEntry();
            entry.key = cacheKey;
            cache.put(cacheKey, entry);
        }
        return entry;
    }

    private static String cacheKey(NodeInterface startNode, NodeInterface endNode) {
        return startNode.getUuid() + endNode.getUuid();
    }

    private static String getUuid(PropertyContainer prop) {
        if (prop.hasProperty("id")) {
            return (String)prop.getProperty("id");
        }
        return null;
    }

    private static class CacheEntry {
        protected Set<String> uuids = new HashSet<String>();
        protected Set<String> relTypes = new HashSet<String>();
        protected PermissionResolutionMask mask = null;
        protected String key = null;

        private CacheEntry() {
        }
    }
}

