/*
 * Decompiled with CFR 0.152.
 */
package org.structr.common;

import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.graph.NodeInterface;
import org.structr.core.graph.Tx;
import org.structr.core.property.PropertyKey;

public class GraphMergeHelper {
    private static final Logger logger = LoggerFactory.getLogger((String)GraphMergeHelper.class.getName());

    public static <T extends NodeInterface> void merge(Set<T> origNodes, Set<T> newNodes, PropertyKey shadowIdPropertyKey) {
        App app = StructrApp.getInstance();
        try (Tx tx = app.tx();){
            for (NodeInterface origNode : origNodes) {
                origNode.setProperty(NodeInterface.deleted, true);
                for (NodeInterface newNode : newNodes) {
                    String shadowId = (String)newNode.getProperty(shadowIdPropertyKey);
                    logger.info("New node shadow id: {}", (Object)shadowId);
                    if (!origNode.getUuid().equals(shadowId)) continue;
                    origNode.setProperty(NodeInterface.deleted, false);
                }
            }
            for (NodeInterface origNode : origNodes) {
                if (!origNode.getProperty(NodeInterface.deleted).booleanValue()) continue;
                app.delete(origNode);
            }
            for (NodeInterface newNode : newNodes) {
                app.delete(newNode);
            }
            tx.success();
        }
        catch (FrameworkException ex) {
            logger.error("", (Throwable)ex);
        }
    }
}

