/*
 * Decompiled with CFR 0.152.
 */
package org.structr.common;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.ViewTransformation;
import org.structr.core.entity.AbstractNode;
import org.structr.core.property.PropertyKey;

public class GraphObjectComparator
extends ViewTransformation<GraphObject>
implements Comparator<GraphObject> {
    public static final String ASCENDING = "asc";
    public static final String DESCENDING = "desc";
    private static final Logger logger = LoggerFactory.getLogger((String)GraphObjectComparator.class.getName());
    private PropertyKey sortKey;
    private String sortOrder;

    public GraphObjectComparator(PropertyKey sortKey, boolean sortDescending) {
        this(sortKey, sortDescending ? DESCENDING : ASCENDING);
    }

    public GraphObjectComparator(PropertyKey sortKey, String sortOrder) {
        this.sortKey = sortKey;
        this.sortOrder = sortOrder;
    }

    @Override
    public int compare(GraphObject n1, GraphObject n2) {
        if (n1 == null || n2 == null) {
            throw new NullPointerException();
        }
        try {
            boolean desc = DESCENDING.equalsIgnoreCase(this.sortOrder);
            Comparable c1 = n1.getComparableProperty(this.sortKey);
            Comparable c2 = n2.getComparableProperty(this.sortKey);
            if (c1 == null || c2 == null) {
                if (c1 == null && c2 == null) {
                    return 0;
                }
                if (c1 == null) {
                    return desc ? -1 : 1;
                }
                return desc ? 1 : -1;
            }
            if (desc) {
                return c2.compareTo(c1);
            }
            return c1.compareTo(c2);
        }
        catch (Throwable t) {
            logger.warn("Cannot compare properties {} of type {} to {} of type {}, property {} error.", new Object[]{n1.getProperty(GraphObject.id), n1.getProperty(AbstractNode.type), n2.getProperty(GraphObject.id), n2.getProperty(AbstractNode.type), this.sortKey});
            return 0;
        }
    }

    @Override
    public void apply(SecurityContext securityContext, List<GraphObject> obj) throws FrameworkException {
        Collections.sort(obj, this);
    }

    @Override
    public int getOrder() {
        return 998;
    }

    @Override
    public boolean evaluateWrappedResource() {
        return true;
    }
}

