/*
 * Decompiled with CFR 0.152.
 */
package org.structr.common;

import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.mail.Email;
import org.apache.commons.mail.EmailAttachment;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.HtmlEmail;
import org.apache.commons.mail.SimpleEmail;
import org.structr.api.config.Settings;

public abstract class MailHelper {
    private static final String charset = "UTF-8";

    public static String sendHtmlMail(String from, String fromName, String to, String toName, String cc, String bcc, String bounce, String subject, String htmlContent, String textContent, EmailAttachment ... attachments) throws EmailException {
        if (((Boolean)Settings.SmtpTesting.getValue()).booleanValue()) {
            return "Testing";
        }
        HtmlEmail mail = new HtmlEmail();
        MailHelper.setup((Email)mail, to, toName, from, fromName, cc, bcc, bounce, subject);
        mail.setHtmlMsg(htmlContent);
        mail.setTextMsg(textContent);
        if (attachments != null) {
            for (EmailAttachment attachment : attachments) {
                mail.attach(attachment);
            }
        }
        return mail.send();
    }

    public static String sendSimpleMail(String from, String fromName, String to, String toName, String cc, String bcc, String bounce, String subject, String textContent) throws EmailException {
        SimpleEmail mail = new SimpleEmail();
        MailHelper.setup((Email)mail, to, toName, from, fromName, cc, bcc, bounce, subject);
        mail.setMsg(textContent);
        return mail.send();
    }

    private static void setup(Email mail, String to, String toName, String from, String fromName, String cc, String bcc, String bounce, String subject) throws EmailException {
        String smtpHost = (String)Settings.SmtpHost.getValue();
        int smtpPort = (Integer)Settings.SmtpPort.getValue();
        String smtpUser = (String)Settings.SmtpUser.getValue();
        String smtpPassword = (String)Settings.SmtpPassword.getValue();
        boolean smtpUseTLS = (Boolean)Settings.SmtpTlsEnabled.getValue();
        boolean smtpRequireTLS = (Boolean)Settings.SmtpTlsRequired.getValue();
        mail.setCharset(charset);
        mail.setHostName(smtpHost);
        mail.setSmtpPort(smtpPort);
        mail.setStartTLSEnabled(smtpUseTLS);
        mail.setStartTLSRequired(smtpRequireTLS);
        mail.setCharset(charset);
        if (StringUtils.isNotBlank((CharSequence)smtpUser) && StringUtils.isNotBlank((CharSequence)smtpPassword)) {
            mail.setAuthentication(smtpUser, smtpPassword);
        }
        mail.addTo(to, toName);
        mail.setFrom(from, fromName);
        if (StringUtils.isNotBlank((CharSequence)cc)) {
            mail.addCc(cc);
        }
        if (StringUtils.isNotBlank((CharSequence)bcc)) {
            mail.addBcc(bcc);
        }
        if (StringUtils.isNotBlank((CharSequence)bounce)) {
            mail.setBounceAddress(bounce);
        }
        mail.setSubject(subject);
    }

    public static String replacePlaceHoldersInTemplate(String template, Map<String, String> replacementMap) {
        ArrayList<String> toReplace = new ArrayList<String>();
        ArrayList<String> replaceBy = new ArrayList<String>();
        for (Map.Entry<String, String> property : replacementMap.entrySet()) {
            toReplace.add(property.getKey());
            replaceBy.add(property.getValue());
        }
        return StringUtils.replaceEachRepeatedly((String)template, (String[])toReplace.toArray(new String[toReplace.size()]), (String[])replaceBy.toArray(new String[replaceBy.size()]));
    }
}

