/*
 * Decompiled with CFR 0.152.
 */
package org.structr.common;

import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.core.GraphObject;
import org.structr.core.Result;

public class PagingHelper {
    private static final Logger logger = LoggerFactory.getLogger((String)PagingHelper.class.getName());

    public static List<? extends GraphObject> subList(List<? extends GraphObject> list, int pageSize, int page, String offsetId) {
        int fromIndex;
        if (pageSize <= 0 || page == 0) {
            return Collections.EMPTY_LIST;
        }
        int size = list.size();
        if (StringUtils.isNotBlank((CharSequence)offsetId)) {
            int offsetIndex = 0;
            int i = 0;
            for (GraphObject graphObject : list) {
                if (graphObject.getUuid().equals(offsetId)) {
                    offsetIndex = i;
                    break;
                }
                ++i;
            }
            fromIndex = page > 0 ? offsetIndex : offsetIndex + page * pageSize;
        } else {
            fromIndex = page > 0 ? (page - 1) * pageSize : size + page * pageSize;
        }
        int toIndex = fromIndex + pageSize;
        int finalFromIndex = Math.max(0, fromIndex);
        int finalToIndex = Math.min(size, Math.max(0, toIndex));
        if (finalFromIndex > finalToIndex) {
            finalFromIndex = finalToIndex;
        }
        try {
            return list.subList(finalFromIndex, finalToIndex);
        }
        catch (Throwable t) {
            logger.warn("Invalid range for sublist in paging, pageSize {}, page {}, offsetId {}: {}", new Object[]{pageSize, page, offsetId, t.getMessage()});
            return Collections.EMPTY_LIST;
        }
    }

    public static Result subResult(Result result, int pageSize, int page, String offsetId) {
        if (pageSize <= 0 || page == 0) {
            return result;
        }
        int pageCount = PagingHelper.getPageCount(result.getRawResultCount(), pageSize);
        if (pageCount > 0) {
            result.setPageCount(pageCount);
        }
        if (page > pageCount) {
            page = pageCount;
        }
        result.setPage(page);
        result.setPageSize(pageSize);
        return new Result<GraphObject>(PagingHelper.subList(result.getResults(), pageSize, page, offsetId), result.getResults().size(), result.isCollection(), result.isPrimitiveArray());
    }

    public static Result addPagingParameter(Result result, int pageSize, int page) {
        if (pageSize > 0 && pageSize < Integer.MAX_VALUE) {
            int pageCount = PagingHelper.getPageCount(result.getRawResultCount(), pageSize);
            if (pageCount > 0) {
                result.setPageCount(pageCount);
            }
            result.setPage(page);
            result.setPageSize(pageSize);
        }
        return result;
    }

    private static int getPageCount(int resultCount, int pageSize) {
        return (int)Math.rint(Math.ceil((double)resultCount / (double)pageSize));
    }
}

