/*
 * Decompiled with CFR 0.152.
 */
package org.structr.common;

import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.structr.common.SecurityContext;

public class PathHelper {
    public static final String PATH_SEP = "/";
    private SecurityContext securityContext;

    public PathHelper(SecurityContext securityContext) {
        this.securityContext = securityContext;
    }

    public static void main(String[] args) {
        String[] input = new String[]{"/blog//blog_entries/892fa9194a36427bb87e18641c217d7d/comments", "/img/blog.gif", "blog"};
        for (int i = 0; i < input.length; ++i) {
            String[] parts;
            String path = input[i];
            System.out.println("################### Testing " + path + " ###################");
            String name = PathHelper.getName(path);
            String pagePart = PathHelper.getParts(path)[0];
            System.out.println("Name: " + name);
            System.out.println("Page part: " + pagePart);
            for (String part : parts = PathHelper.getParts(path)) {
                System.out.println(part);
            }
            System.out.println();
        }
    }

    public static String clean(String path) {
        return StringUtils.strip((String)path, (String)PATH_SEP);
    }

    public static String replaceWhitespaceByPlus(String path) {
        return StringUtils.replace((String)path, (String)" ", (String)"+");
    }

    public static String replaceWhitespaceByPercentTwenty(String path) {
        return StringUtils.replace((String)path, (String)" ", (String)"%20");
    }

    public static String getRelativeNodePath(String basePath, String targetPath) {
        String[] targetAncestors;
        if (basePath.equals(targetPath)) {
            return ".";
        }
        if (basePath.equals(PATH_SEP) && targetPath.length() > 1) {
            return targetPath.substring(1);
        }
        String[] baseAncestors = FilenameUtils.normalizeNoEndSeparator((String)basePath).split(PATH_SEP);
        int length = baseAncestors.length < (targetAncestors = FilenameUtils.normalizeNoEndSeparator((String)targetPath).split(PATH_SEP)).length ? baseAncestors.length : targetAncestors.length;
        int lastCommonRoot = -1;
        int i = 0;
        while (i < length && baseAncestors[i].equals(targetAncestors[i])) {
            lastCommonRoot = i++;
        }
        if (lastCommonRoot != -1) {
            StringBuilder newRelativePath = new StringBuilder();
            for (i = lastCommonRoot + 1; i < baseAncestors.length; ++i) {
                if (baseAncestors[i].length() <= 0) continue;
                newRelativePath.append("../");
            }
            for (i = lastCommonRoot + 1; i < targetAncestors.length; ++i) {
                newRelativePath.append(targetAncestors[i]).append(PATH_SEP);
            }
            String result = newRelativePath.toString();
            if (result.endsWith(PATH_SEP)) {
                result = result.substring(0, result.length() - 1);
            }
            return result;
        }
        return targetPath;
    }

    public static String getName(String path) {
        String cleanedPath = PathHelper.clean(path);
        if (cleanedPath != null && cleanedPath.contains(PATH_SEP)) {
            return StringUtils.substringAfterLast((String)cleanedPath, (String)PATH_SEP);
        }
        return cleanedPath;
    }

    public static String getFolderPath(String path) {
        String cleanedPath = PathHelper.clean(path);
        if (cleanedPath != null && cleanedPath.contains(PATH_SEP)) {
            return PATH_SEP + StringUtils.substringBeforeLast((String)cleanedPath, (String)PATH_SEP);
        }
        return PATH_SEP;
    }

    public static String[] getParts(String path) {
        String cleanedPath = PathHelper.clean(path);
        return StringUtils.splitByWholeSeparator((String)cleanedPath, (String)PATH_SEP);
    }
}

