/*
 * Decompiled with CFR 0.152.
 */
package org.structr.common;

import org.apache.commons.lang.StringUtils;
import org.structr.api.Predicate;
import org.structr.api.graph.Node;
import org.structr.api.graph.PropertyContainer;
import org.structr.api.graph.Relationship;
import org.structr.core.GraphObject;
import org.structr.core.Services;
import org.structr.schema.ConfigurationProvider;

public class StructrAndSpatialPredicate<T extends PropertyContainer>
implements Predicate<T> {
    private static final String typeName = GraphObject.type.dbName();
    private static final String idName = GraphObject.id.dbName();
    private ConfigurationProvider configuration = Services.getInstance().getConfigurationProvider();
    private boolean includeStructr = false;
    private boolean includeSpatial = false;
    private boolean includeOther = false;

    public StructrAndSpatialPredicate(boolean includeStructrEntities, boolean includeSpatialEntities, boolean includeOtherNodes) {
        this.includeStructr = includeStructrEntities;
        this.includeSpatial = includeSpatialEntities;
        this.includeOther = includeOtherNodes;
    }

    public boolean accept(T container) {
        boolean isStructrEntity = this.isStructrEntity(container);
        if (container instanceof Node) {
            boolean isSpatialEntity = container.isSpatialEntity();
            if (isStructrEntity) {
                return this.includeStructr;
            }
            if (isSpatialEntity) {
                return this.includeSpatial;
            }
            return this.includeOther;
        }
        if (container instanceof Relationship) {
            boolean isSpatialEntity = container.isSpatialEntity();
            if (isStructrEntity) {
                return this.includeStructr;
            }
            if (isSpatialEntity) {
                return this.includeSpatial;
            }
            return this.includeOther;
        }
        return true;
    }

    private boolean isStructrEntity(T container) {
        Object typeObject;
        String id;
        Object idObject;
        if (container.hasProperty(idName) && (idObject = container.getProperty(idName)) instanceof String && (id = (String)idObject).length() == 32 && StringUtils.isAlphanumeric((String)id) && container.hasProperty(typeName) && (typeObject = container.getProperty(typeName)) instanceof String) {
            String type = (String)typeObject;
            if (this.configuration.getNodeEntities().containsKey(type)) {
                return true;
            }
            if (this.configuration.getRelationshipEntities().containsKey(type)) {
                return true;
            }
        }
        return false;
    }
}

