/*
 * Decompiled with CFR 0.152.
 */
package org.structr.common;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;

public class SyncState {
    private final Set<Flag> flags = EnumSet.noneOf(Flag.class);

    public boolean hasFlag(Flag flag) {
        return this.flags.contains((Object)flag);
    }

    public boolean hasFlags(Flag ... hasFlags) {
        return this.flags.containsAll(Arrays.asList(hasFlags));
    }

    public static SyncState all() {
        SyncState syncState = new SyncState();
        syncState.flags.addAll(Arrays.asList(Flag.values()));
        return syncState;
    }

    public static SyncState all(Flag ... flags) {
        SyncState syncState = new SyncState();
        syncState.flags.addAll(Arrays.asList(flags));
        return syncState;
    }

    public static SyncState one(Flag flag) {
        SyncState syncState = new SyncState();
        syncState.flags.add(flag);
        return syncState;
    }

    public static SyncState fromString(String commaSeparatedNameList) {
        SyncState syncState = new SyncState();
        String[] parts = commaSeparatedNameList.split("[, ]+");
        int length = parts.length;
        for (int i = 0; i < length; ++i) {
            try {
                String part = parts[i].trim();
                syncState.flags.add(Flag.valueOf(part));
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return syncState;
    }

    public static enum Flag {
        Pages,
        Files,
        Folders,
        Images,
        Schema;

    }
}

