/*
 * Decompiled with CFR 0.152.
 */
package org.structr.common;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.error.CompoundToken;
import org.structr.common.error.EmptyPropertyToken;
import org.structr.common.error.ErrorBuffer;
import org.structr.common.error.FrameworkException;
import org.structr.common.error.MatchToken;
import org.structr.common.error.RangeToken;
import org.structr.common.error.TooShortToken;
import org.structr.common.error.UniqueToken;
import org.structr.core.GraphObject;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.graph.NodeInterface;
import org.structr.core.graph.RelationshipInterface;
import org.structr.core.property.GenericProperty;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.PropertyMap;

public class ValidationHelper {
    private static final Logger logger = LoggerFactory.getLogger((String)ValidationHelper.class.getName());
    private static final PropertyKey UnknownType = new GenericProperty("unknown type");

    public static boolean isValidStringMinLength(GraphObject node, PropertyKey<String> key, int minLength, ErrorBuffer errorBuffer) {
        String value = node.getProperty(key);
        String type = node.getType();
        if (StringUtils.isNotBlank((CharSequence)value)) {
            if (value.length() >= minLength) {
                return true;
            }
            errorBuffer.add(new TooShortToken(type, key, minLength));
            return false;
        }
        errorBuffer.add(new EmptyPropertyToken(type, key));
        return false;
    }

    public static boolean isValidStringNotBlank(GraphObject node, PropertyKey<String> key, ErrorBuffer errorBuffer) {
        if (StringUtils.isNotBlank((CharSequence)node.getProperty(key))) {
            return true;
        }
        errorBuffer.add(new EmptyPropertyToken(node.getType(), key));
        return false;
    }

    public static boolean isValidPropertyNotNull(GraphObject node, PropertyKey key, ErrorBuffer errorBuffer) {
        String type = node.getType();
        if (key == null) {
            errorBuffer.add(new EmptyPropertyToken(type, UnknownType));
            return false;
        }
        Object value = node.getProperty(key);
        if (value != null) {
            if (value instanceof Iterable) {
                if (((Iterable)value).iterator().hasNext()) {
                    return true;
                }
            } else {
                return true;
            }
        }
        errorBuffer.add(new EmptyPropertyToken(type, key));
        return false;
    }

    public static boolean isValidStringMatchingRegex(GraphObject node, PropertyKey<String> key, String expression, ErrorBuffer errorBuffer) {
        String value = node.getProperty(key);
        if (value != null && value.matches(expression)) {
            return true;
        }
        errorBuffer.add(new MatchToken(node.getType(), key, expression));
        return false;
    }

    public static boolean isValidIntegerInRange(GraphObject node, PropertyKey<Integer> key, String range, ErrorBuffer errorBuffer) {
        int length = range.length();
        String leftBound = range.substring(0, 1);
        String rightBound = range.substring(length - 1, length);
        String[] parts = range.substring(1, length - 1).split(",+");
        String type = node.getType();
        if (parts.length == 2) {
            String leftPart = parts[0].trim();
            String rightPart = parts[1].trim();
            int left = Integer.parseInt(leftPart);
            int right = Integer.parseInt(rightPart);
            Integer value = node.getProperty(key);
            if (value != null) {
                boolean inRange = true;
                inRange = "[".equals(leftBound) ? (inRange &= value >= left) : (inRange &= value > left);
                inRange = "]".equals(rightBound) ? (inRange &= value <= right) : (inRange &= value < right);
                if (!inRange) {
                    errorBuffer.add(new RangeToken(type, key, range));
                }
                return inRange;
            }
        }
        return true;
    }

    public static boolean isValidIntegerArrayInRange(GraphObject node, PropertyKey<Integer[]> key, String range, ErrorBuffer errorBuffer) {
        int length = range.length();
        String leftBound = range.substring(0, 1);
        String rightBound = range.substring(length - 1, length);
        String[] parts = range.substring(1, length - 1).split(",+");
        String type = node.getType();
        if (parts.length == 2) {
            String leftPart = parts[0].trim();
            String rightPart = parts[1].trim();
            int left = Integer.parseInt(leftPart);
            int right = Integer.parseInt(rightPart);
            Integer[] values = node.getProperty(key);
            if (values != null) {
                boolean inRange = true;
                for (Integer value : values) {
                    inRange = "[".equals(leftBound) ? (inRange &= value >= left) : (inRange &= value > left);
                    if ("]".equals(rightBound)) {
                        inRange &= value <= right;
                        continue;
                    }
                    inRange &= value < right;
                }
                if (!inRange) {
                    errorBuffer.add(new RangeToken(type, key, range));
                }
                return inRange;
            }
        }
        return true;
    }

    public static boolean isValidLongInRange(GraphObject node, PropertyKey<Long> key, String range, ErrorBuffer errorBuffer) {
        int length = range.length();
        String leftBound = range.substring(0, 1);
        String rightBound = range.substring(length - 1, length);
        String[] parts = range.substring(1, length - 1).split(",+");
        String type = node.getType();
        if (parts.length == 2) {
            String leftPart = parts[0].trim();
            String rightPart = parts[1].trim();
            long left = Long.parseLong(leftPart);
            long right = Long.parseLong(rightPart);
            Long value = node.getProperty(key);
            if (value != null) {
                boolean inRange = true;
                inRange = "[".equals(leftBound) ? (inRange &= value >= left) : (inRange &= value > left);
                inRange = "]".equals(rightBound) ? (inRange &= value <= right) : (inRange &= value < right);
                if (!inRange) {
                    errorBuffer.add(new RangeToken(type, key, range));
                }
                return inRange;
            }
        }
        return true;
    }

    public static boolean isValidLongArrayInRange(GraphObject node, PropertyKey<Long[]> key, String range, ErrorBuffer errorBuffer) {
        int length = range.length();
        String leftBound = range.substring(0, 1);
        String rightBound = range.substring(length - 1, length);
        String[] parts = range.substring(1, length - 1).split(",+");
        String type = node.getType();
        if (parts.length == 2) {
            String leftPart = parts[0].trim();
            String rightPart = parts[1].trim();
            long left = Long.parseLong(leftPart);
            long right = Long.parseLong(rightPart);
            Long[] values = node.getProperty(key);
            if (values != null) {
                boolean inRange = true;
                for (Long value : values) {
                    inRange = "[".equals(leftBound) ? (inRange &= value >= left) : (inRange &= value > left);
                    if ("]".equals(rightBound)) {
                        inRange &= value <= right;
                        continue;
                    }
                    inRange &= value < right;
                }
                if (!inRange) {
                    errorBuffer.add(new RangeToken(type, key, range));
                }
                return inRange;
            }
        }
        return true;
    }

    public static boolean isValidDoubleInRange(GraphObject node, PropertyKey<Double> key, String range, ErrorBuffer errorBuffer) {
        int length = range.length();
        String leftBound = range.substring(0, 1);
        String rightBound = range.substring(length - 1, length);
        String[] parts = range.substring(1, length - 1).split(",+");
        String type = node.getType();
        if (parts.length == 2) {
            String leftPart = parts[0].trim();
            String rightPart = parts[1].trim();
            double left = Double.parseDouble(leftPart);
            double right = Double.parseDouble(rightPart);
            Double value = node.getProperty(key);
            if (value != null) {
                boolean inRange = true;
                inRange = "[".equals(leftBound) ? (inRange &= value >= left) : (inRange &= value > left);
                inRange = "]".equals(rightBound) ? (inRange &= value <= right) : (inRange &= value < right);
                if (!inRange) {
                    errorBuffer.add(new RangeToken(type, key, range));
                }
                return inRange;
            }
        }
        return true;
    }

    public static boolean isValidDoubleArrayInRange(GraphObject node, PropertyKey<Double[]> key, String range, ErrorBuffer errorBuffer) {
        int length = range.length();
        String leftBound = range.substring(0, 1);
        String rightBound = range.substring(length - 1, length);
        String[] parts = range.substring(1, length - 1).split(",+");
        String type = node.getType();
        if (parts.length == 2) {
            String leftPart = parts[0].trim();
            String rightPart = parts[1].trim();
            double left = Double.parseDouble(leftPart);
            double right = Double.parseDouble(rightPart);
            Double[] values = node.getProperty(key);
            if (values != null) {
                boolean inRange = true;
                for (Double value : values) {
                    inRange = "[".equals(leftBound) ? (inRange &= value >= left) : (inRange &= value > left);
                    if ("]".equals(rightBound)) {
                        inRange &= value <= right;
                        continue;
                    }
                    inRange &= value < right;
                }
                if (!inRange) {
                    errorBuffer.add(new RangeToken(type, key, range));
                }
                return inRange;
            }
        }
        return true;
    }

    public static synchronized boolean isValidUniqueProperty(GraphObject object, PropertyKey key, ErrorBuffer errorBuffer) {
        Object value;
        if (key != null && (value = object.getProperty(key)) != null) {
            List<?> result = null;
            Class<?> type = key.getDeclaringClass();
            if (type == null || AbstractNode.name.equals(key) && NodeInterface.class.equals(type)) {
                type = object.getClass();
            }
            try {
                result = object instanceof NodeInterface ? StructrApp.getInstance().nodeQuery(type).and(key, value).sortDescending(GraphObject.createdDate).getAsList() : StructrApp.getInstance().relationshipQuery(type).and(key, value).sortDescending(GraphObject.createdDate).getAsList();
            }
            catch (FrameworkException fex) {
                logger.warn("", (Throwable)fex);
            }
            if (result != null) {
                for (GraphObject foundNode : result) {
                    if (foundNode.getId() == object.getId()) continue;
                    errorBuffer.add(new UniqueToken(object.getType(), key, object.getUuid()));
                    return false;
                }
            }
        }
        return true;
    }

    public static synchronized boolean areValidCompoundUniqueProperties(GraphObject object, ErrorBuffer errorBuffer, PropertyKey ... keys) {
        if (keys != null && keys.length > 0) {
            PropertyMap properties = new PropertyMap();
            List<?> result = null;
            Class type = null;
            for (PropertyKey key : keys) {
                properties.put(key, object.getProperty(key));
                if (type == null) continue;
                type = key.getDeclaringClass();
            }
            if (type == null) {
                type = object.getClass();
            }
            try {
                result = object instanceof NodeInterface ? StructrApp.getInstance().nodeQuery(type).and(properties).sortDescending(GraphObject.createdDate).getAsList() : StructrApp.getInstance().relationshipQuery(type).and(properties).sortDescending(GraphObject.createdDate).getAsList();
            }
            catch (FrameworkException fex) {
                logger.warn("", (Throwable)fex);
            }
            if (result != null) {
                for (GraphObject foundNode : result) {
                    if (foundNode.getId() == object.getId()) continue;
                    errorBuffer.add(new CompoundToken(object.getType(), keys, object.getUuid()));
                    return false;
                }
            }
        }
        return true;
    }

    public static synchronized boolean isValidGloballyUniqueProperty(GraphObject object, PropertyKey key, ErrorBuffer errorBuffer) {
        if (key != null) {
            List<GraphObject> result;
            block7: {
                Object value = object.getProperty(key);
                result = null;
                try {
                    if (object instanceof NodeInterface) {
                        result = StructrApp.getInstance().nodeQuery().and(key, value).sortDescending(GraphObject.createdDate).getAsList();
                        break block7;
                    }
                    if (object instanceof RelationshipInterface) {
                        result = StructrApp.getInstance().relationshipQuery().and(key, value).sortDescending(GraphObject.createdDate).getAsList();
                        break block7;
                    }
                    logger.error("GraphObject is neither NodeInterface nor RelationshipInterface");
                    return false;
                }
                catch (FrameworkException fex) {
                    logger.warn("Unable to fetch list of nodes for uniqueness check", (Throwable)fex);
                }
            }
            if (result != null) {
                for (GraphObject graphObject : result) {
                    if (graphObject.getId() == object.getId()) continue;
                    errorBuffer.add(new UniqueToken(object.getType(), key, object.getUuid()));
                    return false;
                }
            }
        }
        return true;
    }
}

