/*
 * Decompiled with CFR 0.152.
 */
package org.structr.common.error;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.structr.common.error.ErrorToken;
import org.structr.core.property.PropertyKey;

public class CompoundToken
extends ErrorToken {
    private PropertyKey[] keys = null;

    public CompoundToken(String type, PropertyKey[] keys, String uuid) {
        super(type, null, "already_taken", uuid);
        this.keys = keys;
    }

    @Override
    public Object getValue() {
        return this.keys;
    }

    @Override
    public JsonObject toJSON() {
        JsonObject token = new JsonObject();
        JsonArray array = new JsonArray();
        for (PropertyKey key : this.keys) {
            array.add(key.jsonName());
        }
        token.add("type", this.getStringOrNull(this.getType()));
        token.add("properties", (JsonElement)array);
        token.add("token", this.getStringOrNull(this.getToken()));
        this.addIfNonNull(token, "detail", this.getObjectOrNull(this.getDetail()));
        return token;
    }
}

