/*
 * Decompiled with CFR 0.152.
 */
package org.structr.common.error;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Iterator;
import org.structr.common.error.ErrorBuffer;
import org.structr.common.error.ErrorToken;

public class FrameworkException
extends Exception {
    private final ErrorBuffer errorBuffer = new ErrorBuffer();
    private String message = null;
    private int status = 200;

    public FrameworkException(int status, String message) {
        this(status, message, (ErrorToken)null);
    }

    public FrameworkException(int status, String message, ErrorBuffer errorBuffer) {
        this(status, message, (ErrorToken)null);
        this.errorBuffer.getErrorTokens().addAll(errorBuffer.getErrorTokens());
    }

    public FrameworkException(int status, String message, ErrorToken errorToken) {
        this.status = status;
        this.message = message;
        if (errorToken != null) {
            this.errorBuffer.add(errorToken);
        }
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        if (this.errorBuffer != null) {
            Iterator<ErrorToken> it = this.errorBuffer.getErrorTokens().iterator();
            while (it.hasNext()) {
                ErrorToken token = it.next();
                buf.append(token);
                if (!it.hasNext()) continue;
                buf.append(", ");
            }
        } else {
            buf.append("FrameworkException(").append(this.status).append("): ").append(this.message);
        }
        return buf.toString();
    }

    public JsonElement toJSON() {
        JsonObject container = new JsonObject();
        JsonArray errors = new JsonArray();
        container.add("code", (JsonElement)new JsonPrimitive((Number)this.getStatus()));
        container.add("message", (JsonElement)new JsonPrimitive(this.getMessage()));
        if (this.errorBuffer != null) {
            for (ErrorToken errorToken : this.errorBuffer.getErrorTokens()) {
                errors.add((JsonElement)errorToken.toJSON());
            }
            container.add("errors", (JsonElement)errors);
        }
        return container;
    }

    public ErrorBuffer getErrorBuffer() {
        return this.errorBuffer;
    }

    public int getStatus() {
        return this.status;
    }

    @Override
    public String getMessage() {
        return this.message;
    }
}

