/*
 * Decompiled with CFR 0.152.
 */
package org.structr.common.error;

import org.slf4j.Logger;
import org.structr.api.service.LicenseManager;

public class UnlicensedException
extends RuntimeException {
    private String name = null;
    private String edition = null;

    public UnlicensedException(String name, int editionBitmask) {
        this.edition = LicenseManager.getEdition((int)editionBitmask);
        this.name = name;
    }

    public void log(Logger logger) {
        String msg = this.buildLogMessage();
        if (logger != null) {
            logger.error(msg);
        } else {
            System.out.println(msg);
        }
    }

    public String buildLogMessage() {
        StringBuilder buf = new StringBuilder();
        buf.append("Call to unlicensed StructrScript function ");
        buf.append(this.name);
        buf.append("(). This function is only available in the ");
        buf.append(this.edition);
        buf.append(" Edition and higher. Please contact licensing@structr.com with this error message for more information.");
        return buf.toString();
    }
}

