/*
 * Decompiled with CFR 0.152.
 */
package org.structr.common.geo;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.geo.AbstractGeoCodingProvider;
import org.structr.common.geo.AddressComponent;
import org.structr.common.geo.GeoCodingResult;

public class BingGeoCodingProvider
extends AbstractGeoCodingProvider {
    private static final Logger logger = LoggerFactory.getLogger((String)BingGeoCodingProvider.class.getName());

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public GeoCodingResult geocode(String street, String house, String postalCode, String city, String state, String country, String language) throws IOException {
        if (this.apiKey != null && !this.apiKey.isEmpty()) {
            StringBuilder urlBuffer = new StringBuilder("http://dev.virtualearth.net/REST/v1/Locations");
            urlBuffer.append("?key=").append(this.apiKey);
            urlBuffer.append("&c=").append(language);
            urlBuffer.append("&o=xml");
            urlBuffer.append("&query=");
            if (house != null && !house.isEmpty()) {
                urlBuffer.append(this.encodeURL(house)).append("+");
            }
            if (street != null && !street.isEmpty()) {
                urlBuffer.append(this.encodeURL(street)).append("+");
            }
            if (city != null && !city.isEmpty()) {
                urlBuffer.append(this.encodeURL(city)).append("+");
            }
            if (postalCode != null && !postalCode.isEmpty()) {
                urlBuffer.append("&postalCode=").append(this.encodeURL(postalCode));
            }
            urlBuffer.append("&maxResults=1");
            String url = urlBuffer.toString();
            try {
                logger.info("Using url {}", (Object)url);
                URL mapsUrl = new URL(urlBuffer.toString());
                HttpURLConnection connection = (HttpURLConnection)mapsUrl.openConnection();
                connection.connect();
                InputStreamReader reader = new InputStreamReader(connection.getInputStream());
                SAXReader saxReader = new SAXReader();
                if (((Reader)reader).read() != 65279) {
                    reader.reset();
                }
                Document xmlDoc = saxReader.read((Reader)reader);
                connection.disconnect();
                ((Reader)reader).close();
                if (xmlDoc == null) return null;
                LinkedHashMap<String, String> data = new LinkedHashMap<String, String>();
                Element root = xmlDoc.getRootElement();
                try {
                    data.put("lat", root.element("ResourceSets").element("ResourceSet").element("Resources").element("Location").element("Point").element("Latitude").getTextTrim());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    data.put("lon", root.element("ResourceSets").element("ResourceSet").element("Resources").element("Location").element("Point").element("Longitude").getTextTrim());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    data.put("postalCode", root.element("ResourceSets").element("ResourceSet").element("Resources").element("Location").element("Address").element("PostalCode").getTextTrim());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    data.put("adminDistrict", root.element("ResourceSets").element("ResourceSet").element("Resources").element("Location").element("Address").element("AdminDistrict").getTextTrim());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    data.put("adminDistrict2", root.element("ResourceSets").element("ResourceSet").element("Resources").element("Location").element("Address").element("AdminDistrict2").getTextTrim());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    data.put("locality", root.element("ResourceSets").element("ResourceSet").element("Resources").element("Location").element("Address").element("Locality").getTextTrim());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    data.put("countryRegion", root.element("ResourceSets").element("ResourceSet").element("Resources").element("Location").element("Address").element("CountryRegion").getTextTrim());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (data.containsKey("lat") && data.containsKey("lon")) {
                    String address = (StringUtils.isNotBlank((CharSequence)street) ? street : "") + " " + (StringUtils.isNotBlank((CharSequence)house) ? house : "") + " " + (StringUtils.isNotBlank((CharSequence)postalCode) ? postalCode : "" + (StringUtils.isNotBlank((CharSequence)city) ? city : "") + " " + (StringUtils.isNotBlank((CharSequence)state) ? state : "") + " " + (StringUtils.isNotBlank((CharSequence)country) ? country : "") + " ");
                    return new BingGeoCodingResult(address, data);
                }
                logger.warn("Geocoding result did not contain location information:\n{}", (Object)xmlDoc.asXML());
                return null;
            }
            catch (DocumentException dex) {
                logger.warn("Unable to use Bing geocoding provider: {}", (Object)dex.getMessage());
                throw new IOException(dex);
            }
        }
        logger.warn("Unable to use Bing geocoding provider, missing API key. Please supply API key in structr.conf using the key geocoding.apikey.");
        return null;
    }

    private static class BingAddressComponent
    implements AddressComponent {
        GeoCodingResult.Type type = null;
        String value = null;

        public BingAddressComponent(String value, GeoCodingResult.Type type) {
            this.type = type;
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public GeoCodingResult.Type getType() {
            return this.type;
        }
    }

    private static class BingGeoCodingResult
    implements GeoCodingResult {
        private List<AddressComponent> addressComponents = new LinkedList<AddressComponent>();
        private Double latitude = null;
        private Double longitude = null;
        private String address = null;

        public BingGeoCodingResult(String address, Map<String, String> data) {
            this.address = address;
            this.latitude = Double.parseDouble(data.get("lat"));
            this.longitude = Double.parseDouble(data.get("lon"));
            this.addressComponents.add(new BingAddressComponent(data.get("postalCode"), GeoCodingResult.Type.postal_code));
            this.addressComponents.add(new BingAddressComponent(data.get("adminDistrict"), GeoCodingResult.Type.administrative_area_level_1));
            this.addressComponents.add(new BingAddressComponent(data.get("adminDistrict2"), GeoCodingResult.Type.administrative_area_level_3));
            this.addressComponents.add(new BingAddressComponent(data.get("countryRegion"), GeoCodingResult.Type.country));
            this.addressComponents.add(new BingAddressComponent(data.get("locality"), GeoCodingResult.Type.locality));
        }

        @Override
        public String getAddress() {
            return this.address;
        }

        @Override
        public AddressComponent getAddressComponent(GeoCodingResult.Type type) {
            for (AddressComponent addressComponent : this.addressComponents) {
                if (addressComponent.getType() != type) continue;
                return addressComponent;
            }
            return null;
        }

        @Override
        public List<AddressComponent> getAddressComponents() {
            return this.addressComponents;
        }

        @Override
        public double getLatitude() {
            return this.latitude;
        }

        @Override
        public double getLongitude() {
            return this.longitude;
        }

        @Override
        public void setAddress(String address) {
            this.address = address;
        }

        @Override
        public void setLatitude(double latitude) {
            this.latitude = latitude;
        }

        @Override
        public void setLongitude(double longitude) {
            this.longitude = longitude;
        }

        @Override
        public Double[] toArray() {
            return new Double[]{this.latitude, this.longitude};
        }
    }
}

