/*
 * Decompiled with CFR 0.152.
 */
package org.structr.common.geo;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.geo.AbstractGeoCodingProvider;
import org.structr.common.geo.AddressComponent;
import org.structr.common.geo.GeoCodingResult;

public class GoogleGeoCodingProvider
extends AbstractGeoCodingProvider {
    private static final Logger logger = LoggerFactory.getLogger((String)GoogleGeoCodingProvider.class.getName());

    @Override
    public GeoCodingResult geocode(String street, String house, String postalCode, String city, String state, String country, String language) throws IOException {
        Document xmlDoc;
        String encodedAddress;
        String address = (StringUtils.isNotBlank((CharSequence)street) ? street : "") + " " + (StringUtils.isNotBlank((CharSequence)house) ? house : "") + " " + (StringUtils.isNotBlank((CharSequence)postalCode) ? postalCode : "" + (StringUtils.isNotBlank((CharSequence)city) ? city : "") + " " + (StringUtils.isNotBlank((CharSequence)state) ? state : "") + " " + (StringUtils.isNotBlank((CharSequence)country) ? country : "") + " ");
        try {
            encodedAddress = URLEncoder.encode(address, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            logger.warn("Unsupported Encoding", (Throwable)ex);
            return null;
        }
        try {
            StringBuilder urlBuffer = new StringBuilder("https://maps.google.com/maps/api/geocode/");
            urlBuffer.append("xml");
            urlBuffer.append("?address=").append(encodedAddress);
            urlBuffer.append("&language=").append(language);
            if (this.apiKey != null && !this.apiKey.isEmpty()) {
                urlBuffer.append("&key=").append(this.apiKey);
            }
            URL mapsUrl = new URL(urlBuffer.toString());
            HttpURLConnection connection = (HttpURLConnection)mapsUrl.openConnection();
            connection.connect();
            SAXReader reader = new SAXReader();
            BufferedReader rd = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            xmlDoc = reader.read((Reader)rd);
            connection.disconnect();
            rd.close();
        }
        catch (IOException ioe) {
            logger.warn("Connection to geocoding service failed", (Throwable)ioe);
            return null;
        }
        catch (DocumentException de) {
            logger.warn("Could not read result document", (Throwable)de);
            return null;
        }
        Element root = xmlDoc.getRootElement();
        String status = root.element("status").getTextTrim();
        if ("OK".equals(status)) {
            try {
                return new GoogleGeoCodingResult(address, root);
            }
            catch (Throwable t) {
                logger.warn("Unable to find geocoding for address {}: {}", new Object[]{address, t.getMessage()});
            }
        } else {
            logger.warn("Status not OK for address {}: {}", new Object[]{address, status});
        }
        return null;
    }

    public static class GoogleAddressComponent
    implements AddressComponent {
        private GeoCodingResult.Type type = null;
        private String value = null;

        public GoogleAddressComponent(Element addressComponent) {
            this.value = addressComponent.element("long_name").getTextTrim();
            Iterator typesElement = addressComponent.elementIterator("type");
            while (typesElement.hasNext()) {
                Element typeElement = (Element)typesElement.next();
                String typeName = typeElement.getTextTrim();
                try {
                    this.type = GeoCodingResult.Type.valueOf(typeName);
                    break;
                }
                catch (Throwable t) {
                    logger.warn("Encountered unknown address component type {} while parsing.", (Object)typeName);
                }
            }
        }

        @Override
        public GeoCodingResult.Type getType() {
            return this.type;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }

    public static class GoogleGeoCodingResult
    implements GeoCodingResult {
        private List<AddressComponent> addressComponents = new LinkedList<AddressComponent>();
        private String address = null;
        private double latitude;
        private double longitude;

        public GoogleGeoCodingResult(String address, Element root) {
            this.address = address;
            String latString = root.element("result").element("geometry").element("location").element("lat").getTextTrim();
            String lonString = root.element("result").element("geometry").element("location").element("lng").getTextTrim();
            Iterator addressComponentsElement = root.element("result").elementIterator("address_component");
            while (addressComponentsElement.hasNext()) {
                this.addressComponents.add(new GoogleAddressComponent((Element)addressComponentsElement.next()));
            }
            this.latitude = Double.parseDouble(latString);
            this.longitude = Double.parseDouble(lonString);
        }

        public GoogleGeoCodingResult(double latitude, double longitude) {
            this.latitude = latitude;
            this.longitude = longitude;
        }

        @Override
        public double getLatitude() {
            return this.latitude;
        }

        @Override
        public double getLongitude() {
            return this.longitude;
        }

        @Override
        public void setLatitude(double latitude) {
            this.latitude = latitude;
        }

        @Override
        public void setLongitude(double longitude) {
            this.longitude = longitude;
        }

        @Override
        public Double[] toArray() {
            return new Double[]{this.latitude, this.longitude};
        }

        @Override
        public String getAddress() {
            return this.address;
        }

        @Override
        public void setAddress(String address) {
            this.address = address;
        }

        @Override
        public AddressComponent getAddressComponent(GeoCodingResult.Type type) {
            for (AddressComponent addressComponent : this.addressComponents) {
                if (addressComponent.getType() != type) continue;
                return addressComponent;
            }
            return null;
        }

        @Override
        public List<AddressComponent> getAddressComponents() {
            return this.addressComponents;
        }
    }
}

