/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.Predicate;
import org.structr.api.graph.PropertyContainer;
import org.structr.cmis.CMISInfo;
import org.structr.common.SecurityContext;
import org.structr.common.error.ErrorBuffer;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.StructrApp;
import org.structr.core.converter.PropertyConverter;
import org.structr.core.entity.AbstractNode;
import org.structr.core.entity.AbstractRelationship;
import org.structr.core.graph.CreationContainer;
import org.structr.core.graph.ModificationQueue;
import org.structr.core.graph.NodeInterface;
import org.structr.core.graph.RelationshipInterface;
import org.structr.core.graph.TransactionCommand;
import org.structr.core.property.BooleanProperty;
import org.structr.core.property.ISO8601DateProperty;
import org.structr.core.property.Property;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.PropertyMap;
import org.structr.core.property.StringProperty;
import org.structr.core.property.TypeProperty;
import org.structr.core.property.UuidProperty;
import org.structr.schema.action.ActionContext;

public interface GraphObject {
    public static final Logger logger = LoggerFactory.getLogger(GraphObject.class);
    public static final Property<String> base = new StringProperty("base");
    public static final Property<String> type = new TypeProperty();
    public static final Property<String> id = new UuidProperty();
    public static final Property<Date> createdDate = new ISO8601DateProperty("createdDate").systemInternal().indexed().unvalidated().writeOnce();
    public static final Property<String> createdBy = new StringProperty("createdBy").readOnly().writeOnce().unvalidated();
    public static final Property<Date> lastModifiedDate = new ISO8601DateProperty("lastModifiedDate").systemInternal().passivelyIndexed().unvalidated();
    public static final Property<String> lastModifiedBy = new StringProperty("lastModifiedBy").systemInternal().unvalidated();
    public static final Property<Boolean> visibleToPublicUsers = new BooleanProperty("visibleToPublicUsers").passivelyIndexed();
    public static final Property<Boolean> visibleToAuthenticatedUsers = new BooleanProperty("visibleToAuthenticatedUsers").passivelyIndexed();
    public static final Property<Date> visibilityStartDate = new ISO8601DateProperty("visibilityStartDate");
    public static final Property<Date> visibilityEndDate = new ISO8601DateProperty("visibilityEndDate");
    public static final Property<String> structrChangeLog = new StringProperty("structrChangeLog").unvalidated().readOnly();

    public long getId();

    public String getUuid();

    public String getType();

    public void setSecurityContext(SecurityContext var1);

    public SecurityContext getSecurityContext();

    public PropertyContainer getPropertyContainer();

    public Iterable<PropertyKey> getPropertyKeys(String var1);

    public <T> Object setProperty(PropertyKey<T> var1, T var2) throws FrameworkException;

    default public void setProperties(SecurityContext securityContext, PropertyMap properties) throws FrameworkException {
        CreationContainer container = new CreationContainer(this);
        boolean atLeastOnePropertyChanged = false;
        for (Map.Entry<PropertyKey, Object> attr : properties.entrySet()) {
            Object value;
            PropertyKey key = attr.getKey();
            if (key.indexable(value = attr.getValue())) {
                Class type;
                Object oldValue = this.getProperty(key);
                if (value.equals(oldValue)) continue;
                atLeastOnePropertyChanged = true;
                key.setProperty(securityContext, container, value);
                if (this.isNode()) {
                    if (!key.isUnvalidated()) {
                        TransactionCommand.nodeModified(securityContext.getCachedUser(), (AbstractNode)this, key, this.getProperty(key), value);
                    }
                    if (!(key instanceof TypeProperty) || !(this instanceof NodeInterface)) continue;
                    type = StructrApp.getConfiguration().getNodeEntityClass((String)value);
                    TypeProperty.updateLabels(StructrApp.getInstance().getDatabaseService(), (NodeInterface)this, type);
                    continue;
                }
                if (!this.isRelationship()) continue;
                if (!key.isUnvalidated()) {
                    TransactionCommand.relationshipModified(securityContext.getCachedUser(), (AbstractRelationship)this, key, this.getProperty(key), value);
                }
                if (!(key instanceof TypeProperty) || !(this instanceof NodeInterface)) continue;
                type = StructrApp.getConfiguration().getNodeEntityClass((String)value);
                TypeProperty.updateLabels(StructrApp.getInstance().getDatabaseService(), (NodeInterface)this, type);
                continue;
            }
            if (key.isSystemInternal()) {
                this.unlockSystemPropertiesOnce();
            }
            this.setProperty(key, value);
        }
        if (atLeastOnePropertyChanged) {
            this.getPropertyContainer().setProperties(container.getData());
        }
    }

    default public void addToIndex() {
        for (PropertyKey key : StructrApp.getConfiguration().getPropertySet(this.getEntityType(), "all")) {
            if (!key.isIndexed()) continue;
            PropertyConverter converter = key.databaseConverter(this.getSecurityContext(), this);
            if (converter != null) {
                try {
                    key.index(this, converter.convert(this.getProperty(key)));
                }
                catch (FrameworkException ex) {
                    logger.warn("Unable to convert property {} of type {}: {}", new Object[]{key.dbName(), this.getClass().getSimpleName(), ex.getMessage()});
                    logger.warn("Exception", (Throwable)ex);
                }
                continue;
            }
            key.index(this, this.getProperty(key));
        }
    }

    public <T> T getProperty(PropertyKey<T> var1);

    public <T> T getProperty(PropertyKey<T> var1, Predicate<GraphObject> var2);

    public <T> Comparable getComparableProperty(PropertyKey<T> var1);

    public void removeProperty(PropertyKey var1) throws FrameworkException;

    public PropertyKey getDefaultSortKey();

    public String getDefaultSortOrder();

    public void unlockSystemPropertiesOnce();

    public void unlockReadOnlyPropertiesOnce();

    public boolean isValid(ErrorBuffer var1);

    public boolean onCreation(SecurityContext var1, ErrorBuffer var2) throws FrameworkException;

    public boolean onModification(SecurityContext var1, ErrorBuffer var2, ModificationQueue var3) throws FrameworkException;

    public boolean onDeletion(SecurityContext var1, ErrorBuffer var2, PropertyMap var3) throws FrameworkException;

    public void afterCreation(SecurityContext var1);

    public void afterModification(SecurityContext var1);

    public void afterDeletion(SecurityContext var1, PropertyMap var2);

    public void ownerModified(SecurityContext var1);

    public void securityModified(SecurityContext var1);

    public void locationModified(SecurityContext var1);

    public void propagatedModification(SecurityContext var1);

    public void updateInIndex();

    public void removeFromIndex();

    public void indexPassiveProperties();

    public String getPropertyWithVariableReplacement(ActionContext var1, PropertyKey<String> var2) throws FrameworkException;

    public Object evaluate(ActionContext var1, String var2, String var3) throws FrameworkException;

    public Object invokeMethod(String var1, Map<String, Object> var2, boolean var3) throws FrameworkException;

    public Class getEntityType();

    public List<GraphObject> getSyncData() throws FrameworkException;

    public boolean isNode();

    public boolean isRelationship();

    public NodeInterface getSyncNode();

    public RelationshipInterface getSyncRelationship();

    public CMISInfo getCMISInfo();
}

