/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.error.FrameworkException;
import org.structr.core.Adapter;

public class IterableAdapter<S, T>
implements Iterable<T> {
    private static final Logger logger = LoggerFactory.getLogger(IterableAdapter.class);
    private Iterator<S> sourceIterator = null;
    private Adapter<S, T> adapter = null;
    private int size = -1;

    public IterableAdapter(Iterable<S> source, Adapter<S, T> adapter) {
        this.sourceIterator = source.iterator();
        this.adapter = adapter;
        if (source instanceof Collection) {
            this.size = ((Collection)source).size();
        }
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private T currentValue = null;
            boolean finished = false;
            boolean nextConsumed = true;

            public boolean moveToNextValid() {
                boolean found = false;
                while (!found && IterableAdapter.this.sourceIterator.hasNext()) {
                    try {
                        Object currentTarget = IterableAdapter.this.adapter.adapt(IterableAdapter.this.sourceIterator.next());
                        if (currentTarget == null) continue;
                        found = true;
                        this.currentValue = currentTarget;
                        this.nextConsumed = false;
                    }
                    catch (FrameworkException fex) {
                        logger.warn("Exception in iterator.", (Throwable)fex);
                    }
                }
                if (!found) {
                    this.finished = true;
                }
                return found;
            }

            @Override
            public T next() {
                if (!this.nextConsumed) {
                    this.nextConsumed = true;
                    return this.currentValue;
                }
                if (!this.finished && this.moveToNextValid()) {
                    this.nextConsumed = true;
                    return this.currentValue;
                }
                throw new NoSuchElementException("This iterator is exhausted.");
            }

            @Override
            public boolean hasNext() {
                return !this.finished && (!this.nextConsumed || this.moveToNextValid());
            }

            @Override
            public void remove() {
                IterableAdapter.this.sourceIterator.remove();
            }
        };
    }

    public int size() {
        return this.size;
    }
}

