/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.structr.core.GraphObject;

public class Result<T extends GraphObject> {
    public static final Result EMPTY_RESULT = new Result(Collections.EMPTY_LIST, 0, false, false);
    private boolean isCollection = false;
    private boolean isPrimitiveArray = false;
    private boolean hasPartialContent = false;
    private String propertyView = null;
    private List<T> results = null;
    private String searchString = null;
    private String queryTime = null;
    private String sortOrder = null;
    private String sortKey = null;
    private Integer resultCount = null;
    private Integer pageCount = null;
    private Integer pageSize = null;
    private Integer page = null;
    private GraphObject metaData = null;
    private Object nonGraphObject = null;

    public Result(List<T> listResult, Integer rawResultCount, boolean isCollection, boolean isPrimitiveArray) {
        this.isCollection = isCollection;
        this.isPrimitiveArray = isPrimitiveArray;
        this.results = listResult;
        this.resultCount = rawResultCount != null ? rawResultCount : (this.results != null ? this.results.size() : 0);
    }

    public Result(T singleResult, boolean isPrimitiveArray) {
        this.isCollection = false;
        this.isPrimitiveArray = isPrimitiveArray;
        this.results = new ArrayList<T>();
        this.resultCount = singleResult != null ? 1 : 0;
        if (singleResult != null) {
            this.results.add(singleResult);
        }
    }

    public Result(Object nonGraphObjectResult) {
        this.isCollection = nonGraphObjectResult instanceof Collection;
        this.isPrimitiveArray = false;
        this.results = new ArrayList<T>();
        this.resultCount = this.isCollection ? ((Collection)nonGraphObjectResult).size() : 1;
        this.nonGraphObject = nonGraphObjectResult;
    }

    public String toString() {
        return "Result(" + (this.results != null ? this.results.size() : 0) + ")";
    }

    public T get(int i) {
        return (T)((GraphObject)this.results.get(i));
    }

    public boolean isEmpty() {
        return this.results == null || this.results.isEmpty();
    }

    public List<T> getResults() {
        return this.results;
    }

    public void setQueryTime(String queryTime) {
        this.queryTime = queryTime;
    }

    public String getQueryTime() {
        return this.queryTime;
    }

    public String getSearchString() {
        return this.searchString;
    }

    public void setSearchString(String searchString) {
        this.searchString = searchString;
    }

    public String getSortKey() {
        return this.sortKey;
    }

    public void setSortKey(String sortKey) {
        this.sortKey = sortKey;
    }

    public Integer getRawResultCount() {
        if (this.resultCount != null) {
            return this.resultCount;
        }
        return this.size();
    }

    public void setRawResultCount(Integer resultCount) {
        this.resultCount = resultCount;
    }

    public Integer getPageCount() {
        return this.pageCount;
    }

    public void setPageCount(Integer pageCount) {
        this.pageCount = pageCount;
    }

    public Integer getPage() {
        return this.page;
    }

    public void setPage(Integer page) {
        this.page = page;
    }

    public String getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(String sortOrder) {
        this.sortOrder = sortOrder;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public String getPropertyView() {
        return this.propertyView;
    }

    public void setPropertyView(String propertyView) {
        this.propertyView = propertyView;
    }

    public boolean isCollection() {
        return this.isCollection;
    }

    public boolean isPrimitiveArray() {
        return this.isPrimitiveArray;
    }

    public void setIsPrimitiveArray(boolean isPrimitiveArray) {
        this.isPrimitiveArray = isPrimitiveArray;
    }

    public void setIsCollection(boolean isCollection) {
        this.isCollection = isCollection;
    }

    public int size() {
        return !this.isEmpty() ? this.results.size() : 0;
    }

    public void setHasPartialContent(boolean hasPartialContent) {
        this.hasPartialContent = hasPartialContent;
    }

    public boolean hasPartialContent() {
        return this.hasPartialContent;
    }

    public GraphObject getMetaData() {
        return this.metaData;
    }

    public void setMetaData(GraphObject metaData) {
        this.metaData = metaData;
    }

    public Object getNonGraphObjectResult() {
        return this.nonGraphObject;
    }
}

