/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.converter;

import java.util.LinkedHashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.DatabaseService;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.app.StructrApp;
import org.structr.core.converter.PropertyConverter;
import org.structr.core.cypher.CypherQueryHandler;
import org.structr.core.entity.AbstractNode;
import org.structr.core.graph.GraphDatabaseCommand;

public class CypherQueryConverter
extends PropertyConverter {
    private static final Logger logger = LoggerFactory.getLogger((String)CypherQueryConverter.class.getName());
    private DatabaseService graphDb = null;
    private CypherQueryHandler handler = null;

    public CypherQueryConverter(SecurityContext securityContext, GraphObject entity, CypherQueryHandler handler) {
        super(securityContext, entity);
        this.handler = handler;
        try {
            this.graphDb = StructrApp.getInstance().command(GraphDatabaseCommand.class).execute();
        }
        catch (Throwable t) {
            logger.warn("Unable to create cypher execution engine.");
        }
    }

    public Object convert(Object source) throws FrameworkException {
        return source;
    }

    public Object revert(Object source) {
        if (this.currentObject != null) {
            LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
            String query = this.handler.getQuery();
            String name = (String)this.currentObject.getProperty(AbstractNode.name);
            String uuid = this.currentObject.getProperty(GraphObject.id);
            parameters.put("id", uuid);
            parameters.put("uuid", uuid);
            parameters.put("name", name);
            this.handler.setSecurityContext(this.securityContext);
            try {
                List nodes = (List)this.handler.handleQueryResults(this.graphDb.execute(query, parameters));
                return nodes;
            }
            catch (FrameworkException fex) {
                logger.warn("Exception while executing cypher query {}: {}", new Object[]{query, fex.getMessage()});
            }
        }
        return null;
    }
}

